define(
    'bitbucket/internal/bbui/pull-request-list-table',
    ['module', 'exports', 'react', './paged-table', './pull-request-table/components/author-avatar', './pull-request-table/components/comments', './pull-request-table/components/pull-request-row', './pull-request-table/components/reviewers', './pull-request-table/components/tasks', './pull-request-table/components/web-section', './pull-request-list-table/components/summary'],
    function (module, exports, _react, _pagedTable, _authorAvatar, _comments, _pullRequestRow, _reviewers, _tasks, _webSection, _summary) {
        'use strict';

        Object.defineProperty(exports, "__esModule", {
            value: true
        });

        var _pagedTable2 = _interopRequireDefault(_pagedTable);

        var _authorAvatar2 = _interopRequireDefault(_authorAvatar);

        var _comments2 = _interopRequireDefault(_comments);

        var _pullRequestRow2 = _interopRequireDefault(_pullRequestRow);

        var _reviewers2 = _interopRequireDefault(_reviewers);

        var _tasks2 = _interopRequireDefault(_tasks);

        var _summary2 = _interopRequireDefault(_summary);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                default: obj
            };
        }

        var _extends = Object.assign || function (target) {
            for (var i = 1; i < arguments.length; i++) {
                var source = arguments[i];

                for (var key in source) {
                    if (Object.prototype.hasOwnProperty.call(source, key)) {
                        target[key] = source[key];
                    }
                }
            }

            return target;
        };

        var propTypes = {
            focusedIndex: _react.PropTypes.number,
            pullRequests: _react.PropTypes.array.isRequired, // ideally we'd validate the PR shapes
            allFetchedMessage: _react.PropTypes.string
        };

        var PullRequestListTable = function PullRequestListTable(props) {
            var pullRequests = props.pullRequests;
            return React.createElement(_pagedTable2.default, _extends({}, props, {
                className: 'pull-requests-table',
                allFetchedMessage: AJS.I18n.getText('bitbucket.pull.request.all.fetched'),
                items: pullRequests,
                header: function header() {
                    return React.createElement(
                        _pullRequestRow2.default,
                        null,
                        React.createElement(_summary2.default.Header, { colSpan: 2 }),
                        _webSection.beforeSections.map(function (section) {
                            return React.createElement(_webSection.WebSectionHeader, { key: section.key + '::before', webSection: section });
                        }),
                        React.createElement(_comments2.default.Header, null),
                        React.createElement(_tasks2.default.Header, null),
                        React.createElement(_reviewers2.default.Header, null),
                        _webSection.afterSections.map(function (section) {
                            return React.createElement(_webSection.WebSectionHeader, { key: section.key + '::after', webSection: section });
                        })
                    );
                },
                row: function row(_ref) {
                    var item = _ref.item;
                    var focused = _ref.focused;

                    var pullRequest = item;
                    return React.createElement(
                        _pullRequestRow2.default,
                        { key: pullRequest.id, focused: focused },
                        React.createElement(_authorAvatar2.default, { author: pullRequest.author }),
                        React.createElement(_summary2.default, { pullRequest: pullRequest }),
                        _webSection.beforeSections.map(function (section) {
                            return React.createElement(_webSection.WebSectionCell, { key: section.key + '::before', where: 'before', webSection: section, pullRequest: pullRequest });
                        }),
                        React.createElement(_comments2.default, { pullRequest: pullRequest }),
                        React.createElement(_tasks2.default, { pullRequest: pullRequest }),
                        React.createElement(_reviewers2.default, { pullRequest: pullRequest }),
                        _webSection.afterSections.map(function (section) {
                            return React.createElement(_webSection.WebSectionCell, { key: section.key + '::after', where: 'after', webSection: section, pullRequest: pullRequest });
                        })
                    );
                }
            }));
        };

        PullRequestListTable.propTypes = propTypes;

        exports.default = PullRequestListTable;
        module.exports = exports['default'];
    }
);