define(
    'bitbucket/internal/bbui/pull-request-header/components/reopen-button',
    ['module', 'exports', 'react', 'react-dom', '../../aui-react/spinner'],
    function (module, exports, _react, _reactDom, _spinner) {
        'use strict';

        Object.defineProperty(exports, "__esModule", {
            value: true
        });

        var _spinner2 = _interopRequireDefault(_spinner);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                default: obj
            };
        }

        function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function");
            }
        }

        var _createClass = function () {
            function defineProperties(target, props) {
                for (var i = 0; i < props.length; i++) {
                    var descriptor = props[i];
                    descriptor.enumerable = descriptor.enumerable || false;
                    descriptor.configurable = true;
                    if ("value" in descriptor) descriptor.writable = true;
                    Object.defineProperty(target, descriptor.key, descriptor);
                }
            }

            return function (Constructor, protoProps, staticProps) {
                if (protoProps) defineProperties(Constructor.prototype, protoProps);
                if (staticProps) defineProperties(Constructor, staticProps);
                return Constructor;
            };
        }();

        function _possibleConstructorReturn(self, call) {
            if (!self) {
                throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
            }

            return call && (typeof call === "object" || typeof call === "function") ? call : self;
        }

        function _inherits(subClass, superClass) {
            if (typeof superClass !== "function" && superClass !== null) {
                throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
            }

            subClass.prototype = Object.create(superClass && superClass.prototype, {
                constructor: {
                    value: subClass,
                    enumerable: false,
                    writable: true,
                    configurable: true
                }
            });
            if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
        }

        var defaultProps = {
            enabled: true
        };

        var propTypes = {
            onReOpenClick: _react.PropTypes.func.isRequired,
            enabled: _react.PropTypes.bool
        };

        var ReOpenButton = function (_Component) {
            _inherits(ReOpenButton, _Component);

            function ReOpenButton(props) {
                _classCallCheck(this, ReOpenButton);

                var _this = _possibleConstructorReturn(this, Object.getPrototypeOf(ReOpenButton).call(this, props));

                _this.state = {
                    enabled: props.enabled
                };
                return _this;
            }

            _createClass(ReOpenButton, [{
                key: 'componentWillUpdate',
                value: function componentWillUpdate(nextProps, nextState) {
                    if (!nextState.enabled) {
                        // the spinner will be shown, measure the button and set its width.
                        var node = (0, _reactDom.findDOMNode)(this);
                        // use getBoundingClientRect to get the full width of the
                        // button (including borders)
                        var rect = node.getBoundingClientRect();
                        node.style.width = rect.right - rect.left + 'px';
                    }
                }
            }, {
                key: 'onClick',
                value: function onClick() {
                    var _this2 = this;

                    this.props.onReOpenClick().fail(function () {
                        _this2.setState({ enabled: true });
                    });

                    this.setState({ enabled: false });
                }
            }, {
                key: 'render',
                value: function render() {
                    var _this3 = this;

                    var title = AJS.I18n.getText('bitbucket.component.pull.request.toolbar.reopen.tooltip');
                    var content = AJS.I18n.getText('bitbucket.component.pull.request.toolbar.reopen');

                    if (!this.state.enabled) {
                        content = React.createElement(_spinner2.default, null);
                    }
                    return React.createElement(
                        'button',
                        {
                            onClick: function onClick() {
                                return _this3.onClick();
                            },
                            className: 'aui-button aui-button-primary reopen-button',
                            'aria-disabled': !this.state.enabled,
                            title: title
                        },
                        content
                    );
                }
            }]);

            return ReOpenButton;
        }(_react.Component);

        ReOpenButton.propTypes = propTypes;
        ReOpenButton.defaultProps = defaultProps;

        exports.default = ReOpenButton;
        module.exports = exports['default'];
    }
);