define(
    'bitbucket/internal/bbui/pull-request-header/components/merge-instructions',
    ['module', 'exports', 'react', 'bitbucket/internal/impl/urls', '../../codeblock', '../../models'],
    function (module, exports, _react, _urls, _codeblock, _models) {
        'use strict';

        Object.defineProperty(exports, "__esModule", {
            value: true
        });

        var _urls2 = _interopRequireDefault(_urls);

        var _codeblock2 = _interopRequireDefault(_codeblock);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                default: obj
            };
        }

        function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function");
            }
        }

        function _possibleConstructorReturn(self, call) {
            if (!self) {
                throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
            }

            return call && (typeof call === "object" || typeof call === "function") ? call : self;
        }

        var _createClass = function () {
            function defineProperties(target, props) {
                for (var i = 0; i < props.length; i++) {
                    var descriptor = props[i];
                    descriptor.enumerable = descriptor.enumerable || false;
                    descriptor.configurable = true;
                    if ("value" in descriptor) descriptor.writable = true;
                    Object.defineProperty(target, descriptor.key, descriptor);
                }
            }

            return function (Constructor, protoProps, staticProps) {
                if (protoProps) defineProperties(Constructor.prototype, protoProps);
                if (staticProps) defineProperties(Constructor, staticProps);
                return Constructor;
            };
        }();

        function _inherits(subClass, superClass) {
            if (typeof superClass !== "function" && superClass !== null) {
                throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
            }

            subClass.prototype = Object.create(superClass && superClass.prototype, {
                constructor: {
                    value: subClass,
                    enumerable: false,
                    writable: true,
                    configurable: true
                }
            });
            if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
        }

        var MergeInstructions = function (_Component) {
            _inherits(MergeInstructions, _Component);

            _createClass(MergeInstructions, null, [{
                key: 'propTypes',
                get: function get() {
                    return {
                        stability: _react.PropTypes.oneOf(Object.keys(_models.BranchStability).map(function (k) {
                            return _models.BranchStability[k];
                        })),
                        isAutoMergeConflict: _react.PropTypes.bool,
                        pullRequest: _react.PropTypes.object.isRequired
                    };
                }
            }, {
                key: 'defaultProps',
                get: function get() {
                    return {
                        stability: _models.BranchStability.STABLE
                    };
                }
            }]);

            function MergeInstructions() {
                var _Object$getPrototypeO;

                _classCallCheck(this, MergeInstructions);

                for (var _len = arguments.length, props = Array(_len), _key = 0; _key < _len; _key++) {
                    props[_key] = arguments[_key];
                }

                var _this = _possibleConstructorReturn(this, (_Object$getPrototypeO = Object.getPrototypeOf(MergeInstructions)).call.apply(_Object$getPrototypeO, [this].concat(props)));

                var sourceRepo = _this.props.pullRequest.from_ref.repository;
                var targetRepo = _this.props.pullRequest.to_ref.repository;
                var sourceRemote = null;
                var targetRemote = null;

                if (sourceRepo.id !== targetRepo.id) {
                    sourceRemote = _urls2.default.remote(sourceRepo);
                    targetRemote = _urls2.default.remote(targetRepo);
                }

                _this.refDetails = {
                    sourceBranch: _this.props.pullRequest.from_ref.display_id,
                    targetBranch: _this.props.pullRequest.to_ref.display_id,
                    sourceRemote: sourceRemote,
                    targetRemote: targetRemote
                };
                return _this;
            }

            _createClass(MergeInstructions, [{
                key: 'mergeSteps',
                value: function mergeSteps() {
                    // Stable source branch means we fetch source first and then target, and then merge FETCH_HEAD in to target
                    // (and thus remotely merging the pull request). This is also the  approach for automerge conflicts.
                    if (this.props.stability === _models.BranchStability.STABLE || this.props.isAutoMergeConflict) {
                        return React.createElement(
                            'div',
                            null,
                            React.createElement(
                                'p',
                                null,
                                React.createElement(
                                    'strong',
                                    null,
                                    AJS.I18n.getText('bitbucket.component.pull.request.merge.help.step1'),
                                    ' '
                                ),
                                this.refDetails.targetRemote ? AJS.I18n.getText('bitbucket.component.pull.request.merge.fetch.source.branch.crossrepo') : AJS.I18n.getText('bitbucket.component.pull.request.merge.fetch.source.branch.samerepo')
                            ),
                            React.createElement(
                                _codeblock2.default,
                                { instructionBlock: true },
                                'git fetch ',
                                this.refDetails.sourceRemote ? this.refDetails.sourceRemote : 'origin',
                                ' ',
                                this.refDetails.sourceBranch
                            ),
                            React.createElement(
                                'p',
                                null,
                                React.createElement(
                                    'strong',
                                    null,
                                    AJS.I18n.getText('bitbucket.component.pull.request.merge.help.step2'),
                                    ' '
                                ),
                                AJS.I18n.getText('bitbucket.component.pull.request.merge.source.into.target.resolve.conflicts')
                            ),
                            React.createElement(
                                _codeblock2.default,
                                { instructionBlock: true },
                                React.createElement(
                                    'line',
                                    null,
                                    'git checkout ',
                                    this.refDetails.targetBranch
                                ),
                                React.createElement(
                                    'line',
                                    null,
                                    'git merge FETCH_HEAD'
                                )
                            ),
                            React.createElement(
                                'p',
                                null,
                                React.createElement(
                                    'strong',
                                    null,
                                    AJS.I18n.getText('bitbucket.component.pull.request.merge.help.step3'),
                                    ' '
                                ),
                                AJS.I18n.getText('bitbucket.component.pull.request.merge.help.step3.text')
                            ),
                            React.createElement(
                                _codeblock2.default,
                                { instructionBlock: true },
                                React.createElement(
                                    'line',
                                    null,
                                    'git commit'
                                ),
                                React.createElement(
                                    'line',
                                    null,
                                    'git push ',
                                    this.refDetails.targetRemote ? this.refDetails.targetRemote : 'origin',
                                    ' HEAD'
                                )
                            ),
                            React.createElement(
                                'p',
                                null,
                                React.createElement(
                                    'strong',
                                    null,
                                    AJS.I18n.getText('bitbucket.component.pull.request.merge.help.step4'),
                                    ' '
                                ),
                                AJS.I18n.getText('bitbucket.component.pull.request.merge.merged.remotely')
                            )
                        );
                    }
                    // Unstable source branch means we fetch target first and then source, and then merge FETCH_HEAD in to source
                    return React.createElement(
                        'div',
                        null,
                        React.createElement(
                            'p',
                            null,
                            React.createElement(
                                'strong',
                                null,
                                AJS.I18n.getText('bitbucket.component.pull.request.merge.help.step1'),
                                ' '
                            ),
                            this.refDetails.targetRemote ? AJS.I18n.getText('bitbucket.component.pull.request.merge.help.step1.crossrepo.text') : AJS.I18n.getText('bitbucket.component.pull.request.merge.help.step1.samerepo.text')
                        ),
                        React.createElement(
                            _codeblock2.default,
                            { instructionBlock: true },
                            'git fetch ',
                            this.refDetails.targetRemote ? this.refDetails.targetRemote : 'origin',
                            ' ',
                            this.refDetails.targetBranch
                        ),
                        React.createElement(
                            'p',
                            null,
                            React.createElement(
                                'strong',
                                null,
                                AJS.I18n.getText('bitbucket.component.pull.request.merge.help.step2'),
                                ' '
                            ),
                            AJS.I18n.getText('bitbucket.component.pull.request.merge.help.step2.text')
                        ),
                        React.createElement(
                            _codeblock2.default,
                            { instructionBlock: true },
                            React.createElement(
                                'line',
                                null,
                                'git checkout ',
                                this.refDetails.sourceBranch
                            ),
                            React.createElement(
                                'line',
                                null,
                                'git merge FETCH_HEAD'
                            )
                        ),
                        React.createElement(
                            'p',
                            null,
                            React.createElement(
                                'strong',
                                null,
                                AJS.I18n.getText('bitbucket.component.pull.request.merge.help.step3'),
                                ' '
                            ),
                            AJS.I18n.getText('bitbucket.component.pull.request.merge.help.step3.text')
                        ),
                        React.createElement(
                            _codeblock2.default,
                            { instructionBlock: true },
                            React.createElement(
                                'line',
                                null,
                                'git commit'
                            ),
                            React.createElement(
                                'line',
                                null,
                                'git push ',
                                this.refDetails.sourceRemote ? this.refDetails.sourceRemote : 'origin',
                                ' HEAD'
                            )
                        ),
                        React.createElement(
                            'p',
                            null,
                            React.createElement(
                                'strong',
                                null,
                                AJS.I18n.getText('bitbucket.component.pull.request.merge.help.step4'),
                                ' '
                            ),
                            AJS.I18n.getText('bitbucket.component.pull.request.merge.help.step4.text')
                        )
                    );
                }
            }, {
                key: 'render',
                value: function render() {
                    var intro = AJS.I18n.getText('bitbucket.component.pull.request.merge.help.introduction');
                    if (this.props.isAutoMergeConflict) {
                        intro = AJS.I18n.getText('bitbucket.component.pull.request.automerge.help.introduction');
                    }

                    return React.createElement(
                        'div',
                        { className: 'merge-instructions' },
                        React.createElement(
                            'p',
                            { className: 'intro' },
                            intro
                        ),
                        this.mergeSteps()
                    );
                }
            }]);

            return MergeInstructions;
        }(_react.Component);

        exports.default = MergeInstructions;
        module.exports = exports['default'];
    }
);