define(
    'bitbucket/internal/bbui/pull-request-header/components/merge-button',
    ['module', 'exports', 'classnames', 'jquery', 'react', 'react-dom', '../../aui-react/spinner'],
    function (module, exports, _classnames, _jquery, _react, _reactDom, _spinner) {
        'use strict';

        Object.defineProperty(exports, "__esModule", {
            value: true
        });

        var _classnames2 = _interopRequireDefault(_classnames);

        var _jquery2 = _interopRequireDefault(_jquery);

        var _spinner2 = _interopRequireDefault(_spinner);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                default: obj
            };
        }

        var _extends = Object.assign || function (target) {
            for (var i = 1; i < arguments.length; i++) {
                var source = arguments[i];

                for (var key in source) {
                    if (Object.prototype.hasOwnProperty.call(source, key)) {
                        target[key] = source[key];
                    }
                }
            }

            return target;
        };

        function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function");
            }
        }

        var _createClass = function () {
            function defineProperties(target, props) {
                for (var i = 0; i < props.length; i++) {
                    var descriptor = props[i];
                    descriptor.enumerable = descriptor.enumerable || false;
                    descriptor.configurable = true;
                    if ("value" in descriptor) descriptor.writable = true;
                    Object.defineProperty(target, descriptor.key, descriptor);
                }
            }

            return function (Constructor, protoProps, staticProps) {
                if (protoProps) defineProperties(Constructor.prototype, protoProps);
                if (staticProps) defineProperties(Constructor, staticProps);
                return Constructor;
            };
        }();

        function _possibleConstructorReturn(self, call) {
            if (!self) {
                throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
            }

            return call && (typeof call === "object" || typeof call === "function") ? call : self;
        }

        function _inherits(subClass, superClass) {
            if (typeof superClass !== "function" && superClass !== null) {
                throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
            }

            subClass.prototype = Object.create(superClass && superClass.prototype, {
                constructor: {
                    value: subClass,
                    enumerable: false,
                    writable: true,
                    configurable: true
                }
            });
            if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
        }

        var MergeButton = function (_Component) {
            _inherits(MergeButton, _Component);

            function MergeButton() {
                _classCallCheck(this, MergeButton);

                return _possibleConstructorReturn(this, Object.getPrototypeOf(MergeButton).apply(this, arguments));
            }

            _createClass(MergeButton, [{
                key: 'componentDidMount',
                value: function componentDidMount() {
                    var node = (0, _reactDom.findDOMNode)(this);
                    (0, _jquery2.default)(node).tooltip({
                        gravity: 'ne',
                        live: true
                    });
                }
            }, {
                key: 'componentWillUpdate',
                value: function componentWillUpdate(nextProps) {
                    var node = (0, _reactDom.findDOMNode)(this);
                    if (nextProps.mergeable.isChecking) {
                        // the spinner will be shown, measure the button and set its width.
                        // use getBoundingClientRect to get the full width of the
                        // button (including borders)
                        var rect = node.getBoundingClientRect();
                        node.style.width = rect.right - rect.left + 'px';
                    } else {
                        node.style.width = '';
                    }

                    // need to remove the original-title because tipsy will continue to show
                    // if it is not removed.
                    if (!node.getAttribute('title')) {
                        node.setAttribute('title', node.getAttribute('original-title') || '');
                        node.removeAttribute('original-title');
                    }
                }
            }, {
                key: 'componentDidUpdate',
                value: function componentDidUpdate() {
                    var node = (0, _reactDom.findDOMNode)(this);
                    var enabled = this.props.tooltipVisibility ? 'enable' : 'disable';
                    (0, _jquery2.default)(node).tooltip(enabled);
                }
            }, {
                key: 'onClick',
                value: function onClick() {
                    if (this.props.mergeable.canMerge) {
                        this.props.onMergeClick();
                    } else {
                        this.props.onMergeWarningClick();
                    }
                }
            }, {
                key: 'mergeIssueReason',
                value: function mergeIssueReason() {
                    var title = '';

                    if (!this.props.mergeable.canMerge) {
                        var _props = this.props;
                        var conflicted = _props.conflicted;
                        var _props$vetoes = _props.vetoes;
                        var vetoes = _props$vetoes === undefined ? [] : _props$vetoes;


                        if (conflicted && (!vetoes || vetoes.length === 0)) {
                            title = AJS.I18n.getText('bitbucket.component.pull.request.merge.conflict.tooltip');
                        } else if (vetoes && vetoes.length === 1 && !conflicted) {
                            title = vetoes[0].detailedMessage;
                        } else {
                            title = AJS.I18n.getText('bitbucket.component.pull.request.merge.issue.tooltip');
                        }
                    }
                    return title;
                }
            }, {
                key: 'render',
                value: function render() {
                    var _this2 = this;

                    var mergeable = this.props.mergeable;

                    var enabled = !mergeable.isChecking && mergeable.canMerge;
                    var className = (0, _classnames2.default)('aui-button', 'merge-button');
                    return React.createElement(
                        'button',
                        _extends({
                            onClick: function onClick() {
                                return _this2.onClick();
                            },
                            className: className,
                            'aria-disabled': !enabled,
                            title: this.mergeIssueReason(mergeable.canMerge)
                        }, this.props.extraButtonProps),
                        mergeable.isChecking ? React.createElement(_spinner2.default, null) : AJS.I18n.getText('bitbucket.component.pull.request.toolbar.merge')
                    );
                }
            }], [{
                key: 'propTypes',
                get: function get() {
                    return {
                        conflicted: _react.PropTypes.bool,
                        mergeable: _react.PropTypes.shape({
                            isChecking: _react.PropTypes.bool,
                            canMerge: _react.PropTypes.bool
                        }),
                        onMergeClick: _react.PropTypes.func.isRequired,
                        onMergeWarningClick: _react.PropTypes.func.isRequired,
                        extraButtonProps: _react.PropTypes.object,
                        vetoes: _react.PropTypes.arrayOf(_react.PropTypes.shape({
                            detailedMessage: _react.PropTypes.string.isRequired
                        })),
                        tooltipVisibility: _react.PropTypes.bool
                    };
                }
            }, {
                key: 'defaultProps',
                get: function get() {
                    return {
                        conflicted: false,
                        mergeable: {
                            isChecking: false,
                            canMerge: true
                        },
                        extraButtonProps: {}
                    };
                }
            }]);

            return MergeButton;
        }(_react.Component);

        exports.default = MergeButton;
        module.exports = exports['default'];
    }
);