define(
    'bitbucket/internal/bbui/paged-table',
    ['module', 'exports', 'classnames', 'react', './aui-react/spinner', './scroll-handler'],
    function (module, exports, _classnames, _react, _spinner, _scrollHandler) {
        'use strict';

        Object.defineProperty(exports, "__esModule", {
            value: true
        });

        var _classnames2 = _interopRequireDefault(_classnames);

        var _spinner2 = _interopRequireDefault(_spinner);

        var _scrollHandler2 = _interopRequireDefault(_scrollHandler);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                default: obj
            };
        }

        var propTypes = {
            allFetched: _react.PropTypes.bool.isRequired,
            allFetchedMessage: _react.PropTypes.string,
            bufferPx: _scrollHandler2.default.propTypes.bufferPx,
            className: _react.PropTypes.string,
            focusedIndex: _react.PropTypes.number,
            header: _react.PropTypes.func,
            items: _react.PropTypes.array.isRequired,
            loading: _react.PropTypes.bool.isRequired,
            onMoreItemsRequested: _react.PropTypes.func.isRequired,
            row: _react.PropTypes.func.isRequired,
            scrollElement: _scrollHandler2.default.propTypes.scrollElement
        };

        var PagedTable = function PagedTable(props) {
            var VISIBLE_PRS = 7;
            var rows = props.row ? props.items.map(function (item, i) {
                return props.row({
                    item: item,
                    focused: props.focusedIndex === i
                });
            }) : null;

            return React.createElement(
                'div',
                { className: 'paged-table-container' },
                React.createElement(
                    _scrollHandler2.default,
                    {
                        bufferPx: props.bufferPx,
                        onScrollToBottom: props.onMoreItemsRequested,
                        scrollElement: props.scrollElement,
                        suspend: props.allFetched || props.loading
                    },
                    React.createElement(
                        'table',
                        { className: (0, _classnames2.default)("aui paged-table", props.className) },
                        props.header && React.createElement(
                            'thead',
                            null,
                            props.header()
                        ),
                        React.createElement(
                            'tbody',
                            null,
                            rows
                        )
                    )
                ),
                props.loading && React.createElement(_spinner2.default, null),
                props.allFetched && !props.loading && props.items.length > VISIBLE_PRS && React.createElement(
                    'div',
                    { className: 'paged-table-message' },
                    props.allFetchedMessage
                )
            );
        };

        PagedTable.propTypes = propTypes;

        exports.default = PagedTable;
        module.exports = exports['default'];
    }
);