define(
    'bitbucket/internal/bbui/filter-bar/components/select',
    ['module', 'exports', 'jquery', 'lodash', 'react', 'react-dom', './filter'],
    function (module, exports, _jquery, _lodash, _react, _reactDom, _filter) {
        'use strict';

        Object.defineProperty(exports, "__esModule", {
            value: true
        });

        var _jquery2 = _interopRequireDefault(_jquery);

        var _lodash2 = _interopRequireDefault(_lodash);

        var _reactDom2 = _interopRequireDefault(_reactDom);

        var _filter2 = _interopRequireDefault(_filter);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                default: obj
            };
        }

        function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function");
            }
        }

        var _createClass = function () {
            function defineProperties(target, props) {
                for (var i = 0; i < props.length; i++) {
                    var descriptor = props[i];
                    descriptor.enumerable = descriptor.enumerable || false;
                    descriptor.configurable = true;
                    if ("value" in descriptor) descriptor.writable = true;
                    Object.defineProperty(target, descriptor.key, descriptor);
                }
            }

            return function (Constructor, protoProps, staticProps) {
                if (protoProps) defineProperties(Constructor.prototype, protoProps);
                if (staticProps) defineProperties(Constructor, staticProps);
                return Constructor;
            };
        }();

        function _possibleConstructorReturn(self, call) {
            if (!self) {
                throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
            }

            return call && (typeof call === "object" || typeof call === "function") ? call : self;
        }

        function _inherits(subClass, superClass) {
            if (typeof superClass !== "function" && superClass !== null) {
                throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
            }

            subClass.prototype = Object.create(superClass && superClass.prototype, {
                constructor: {
                    value: subClass,
                    enumerable: false,
                    writable: true,
                    configurable: true
                }
            });
            if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
        }

        var Select = function (_Filter) {
            _inherits(Select, _Filter);

            function Select() {
                _classCallCheck(this, Select);

                return _possibleConstructorReturn(this, Object.getPrototypeOf(Select).apply(this, arguments));
            }

            _createClass(Select, [{
                key: 'componentDidMount',
                value: function componentDidMount() {
                    var _this2 = this;

                    var defaults = {
                        minimumResultsForSearch: -1 };
                    // don't show the search box.
                    var overrides = {};
                    var $filter = this.get$Input();
                    $filter.auiSelect2(_lodash2.default.extend(defaults, this.props.menu, overrides));
                    $filter.on('change', function () {
                        return _this2.props.onChange();
                    });
                }
            }, {
                key: 'shouldComponentUpdate',
                value: function shouldComponentUpdate() {
                    return false;
                }
            }, {
                key: 'get$Input',
                value: function get$Input() {
                    return (0, _jquery2.default)(_reactDom2.default.findDOMNode(this)).children('select');
                }
            }, {
                key: 'render',
                value: function render() {
                    return React.createElement(
                        'li',
                        null,
                        React.createElement(
                            'label',
                            { htmlFor: this.props.id, className: 'assistive' },
                            this.props.label
                        ),
                        React.createElement(
                            'select',
                            { id: this.props.id, value: this.props.value, readOnly: true },
                            this.props.menu.items.map(function (item) {
                                return React.createElement(
                                    'option',
                                    { key: item.id, value: item.id, disabled: item.disabled },
                                    item.text
                                );
                            })
                        )
                    );
                }
            }, {
                key: 'value',
                value: function value() {
                    return this.props.value;
                }
            }, {
                key: 'domValue',
                value: function domValue() {
                    return this.get$Input().val();
                }
            }, {
                key: 'reset',
                value: function reset() {
                    var $filter = this.get$Input();
                    $filter.select2('val', this.props.menu.items[0].id);
                    return _jquery2.default.Deferred().resolve();
                }
            }], [{
                key: 'propTypes',
                get: function get() {
                    return {
                        id: _react.PropTypes.string.isRequired,
                        label: _react.PropTypes.string.isRequired,
                        menu: _react.PropTypes.any,
                        onChange: _react.PropTypes.func,
                        value: _react.PropTypes.string
                    };
                }
            }]);

            return Select;
        }(_filter2.default);

        exports.default = Select;
        module.exports = exports['default'];
    }
);