define(
    'bitbucket/internal/bbui/branch-from-to',
    ['module', 'exports', 'aui', 'classnames', 'react', 'react-dom', './aui-react/avatar'],
    function (module, exports, _aui, _classnames, _react, _reactDom, _avatar) {
        'use strict';

        Object.defineProperty(exports, "__esModule", {
            value: true
        });

        var _aui2 = _interopRequireDefault(_aui);

        var _classnames2 = _interopRequireDefault(_classnames);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                default: obj
            };
        }

        function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function");
            }
        }

        var _createClass = function () {
            function defineProperties(target, props) {
                for (var i = 0; i < props.length; i++) {
                    var descriptor = props[i];
                    descriptor.enumerable = descriptor.enumerable || false;
                    descriptor.configurable = true;
                    if ("value" in descriptor) descriptor.writable = true;
                    Object.defineProperty(target, descriptor.key, descriptor);
                }
            }

            return function (Constructor, protoProps, staticProps) {
                if (protoProps) defineProperties(Constructor.prototype, protoProps);
                if (staticProps) defineProperties(Constructor, staticProps);
                return Constructor;
            };
        }();

        function _possibleConstructorReturn(self, call) {
            if (!self) {
                throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
            }

            return call && (typeof call === "object" || typeof call === "function") ? call : self;
        }

        function _inherits(subClass, superClass) {
            if (typeof superClass !== "function" && superClass !== null) {
                throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
            }

            subClass.prototype = Object.create(superClass && superClass.prototype, {
                constructor: {
                    value: subClass,
                    enumerable: false,
                    writable: true,
                    configurable: true
                }
            });
            if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
        }

        var propTypes = {
            fromRef: _react.PropTypes.object.isRequired,
            toRef: _react.PropTypes.object.isRequired
        };

        var BranchFromTo = function (_Component) {
            _inherits(BranchFromTo, _Component);

            function BranchFromTo() {
                _classCallCheck(this, BranchFromTo);

                return _possibleConstructorReturn(this, Object.getPrototypeOf(BranchFromTo).apply(this, arguments));
            }

            _createClass(BranchFromTo, [{
                key: 'componentDidMount',
                value: function componentDidMount() {
                    var node = (0, _reactDom.findDOMNode)(this);
                    _aui2.default.$('.ref-name', node).tooltip();
                }
            }, {
                key: 'componentWillUnmount',
                value: function componentWillUnmount() {
                    var node = (0, _reactDom.findDOMNode)(this);
                    _aui2.default.$('.ref-name', node).tooltip('destroy');
                }
            }, {
                key: 'refItem',
                value: function refItem(ref, type, sameProject, sameRepo) {
                    var showProject = !sameProject;
                    var showRepo = sameProject && !sameRepo;
                    var avatar = this.projectAvatar(ref, showProject);

                    return React.createElement(
                        'div',
                        { className: (0, _classnames2.default)('ref-name', 'ref-name-' + type, { 'with-avatar': avatar }), title: this.refTitle(ref) },
                        avatar,
                        this.displayTitle(ref, showRepo)
                    );
                }
            }, {
                key: 'projectAvatar',
                value: function projectAvatar(ref, differentProject) {
                    if (differentProject) {
                        return React.createElement(
                            'span',
                            { className: 'avatar-to-project avatar-ref-project' },
                            React.createElement(_avatar.ProjectAvatar, {
                                size: 'xsmall',
                                project: ref.repository.project,
                                tagName: 'span'
                            })
                        );
                    }
                }
            }, {
                key: 'displayTitle',
                value: function displayTitle(ref, showRepo) {
                    if (showRepo) {
                        return React.createElement(
                            'span',
                            null,
                            React.createElement(
                                'span',
                                { className: 'repo-name' },
                                ref.repository.name
                            ),
                            React.createElement('span', { className: 'repo-name-icon' }),
                            React.createElement(
                                'span',
                                { className: 'branch-name' },
                                ref.display_id
                            )
                        );
                    }
                    return React.createElement(
                        'span',
                        { className: 'branch-name' },
                        ref.display_id
                    );
                }
            }, {
                key: 'refTitle',
                value: function refTitle(ref) {
                    return ref.repository.project.name + ' / ' + ref.repository.name + ' / ' + ref.display_id;
                }
            }, {
                key: 'render',
                value: function render() {
                    var _props = this.props;
                    var fromRef = _props.fromRef;
                    var toRef = _props.toRef;

                    var sameProject = fromRef.repository.project.id === toRef.repository.project.id;
                    var sameRepo = fromRef.repository.id === toRef.repository.id;

                    return React.createElement(
                        'div',
                        { className: 'branch-from-to' },
                        this.refItem(fromRef, 'from', sameProject, sameRepo),
                        React.createElement(
                            'div',
                            { className: 'aui-icon aui-icon-small aui-iconfont-devtools-arrow-right arrow' },
                            'to'
                        ),
                        this.refItem(toRef, 'to', sameProject, sameRepo)
                    );
                }
            }]);

            return BranchFromTo;
        }(_react.Component);

        BranchFromTo.propTypes = propTypes;

        exports.default = BranchFromTo;
        module.exports = exports['default'];
    }
);