define(
    'bitbucket/internal/bbui/aui-react/inline-dialog',
    ['exports', 'classnames', 'react', './component'],
    function (exports, _classnames, _react, _component) {
        'use strict';

        Object.defineProperty(exports, "__esModule", {
            value: true
        });
        exports.InlineDialogTrigger = undefined;

        var _classnames2 = _interopRequireDefault(_classnames);

        var _react2 = _interopRequireDefault(_react);

        var _component2 = _interopRequireDefault(_component);

        function _interopRequireDefault(obj) {
            return obj && obj.__esModule ? obj : {
                default: obj
            };
        }

        var _extends = Object.assign || function (target) {
            for (var i = 1; i < arguments.length; i++) {
                var source = arguments[i];

                for (var key in source) {
                    if (Object.prototype.hasOwnProperty.call(source, key)) {
                        target[key] = source[key];
                    }
                }
            }

            return target;
        };

        function _classCallCheck(instance, Constructor) {
            if (!(instance instanceof Constructor)) {
                throw new TypeError("Cannot call a class as a function");
            }
        }

        var _createClass = function () {
            function defineProperties(target, props) {
                for (var i = 0; i < props.length; i++) {
                    var descriptor = props[i];
                    descriptor.enumerable = descriptor.enumerable || false;
                    descriptor.configurable = true;
                    if ("value" in descriptor) descriptor.writable = true;
                    Object.defineProperty(target, descriptor.key, descriptor);
                }
            }

            return function (Constructor, protoProps, staticProps) {
                if (protoProps) defineProperties(Constructor.prototype, protoProps);
                if (staticProps) defineProperties(Constructor, staticProps);
                return Constructor;
            };
        }();

        function _possibleConstructorReturn(self, call) {
            if (!self) {
                throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
            }

            return call && (typeof call === "object" || typeof call === "function") ? call : self;
        }

        function _inherits(subClass, superClass) {
            if (typeof superClass !== "function" && superClass !== null) {
                throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
            }

            subClass.prototype = Object.create(superClass && superClass.prototype, {
                constructor: {
                    value: subClass,
                    enumerable: false,
                    writable: true,
                    configurable: true
                }
            });
            if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
        }

        var triggerPropTypes = {
            children: _react.PropTypes.node,
            className: _react.PropTypes.string,
            dialogId: _react.PropTypes.string.isRequired,
            href: _react.PropTypes.string,
            title: _react.PropTypes.string
        };

        var triggerDefaultProps = {
            className: '',
            href: '',
            title: ''
        };

        var dialogPropTypes = {
            alignment: _react.PropTypes.string,
            children: _react.PropTypes.node,
            className: _react.PropTypes.string,
            id: _react.PropTypes.string.isRequired
        };

        var dialogDefaultProps = {
            alignment: 'right middle',
            className: ''
        };

        /**
         * Creates a click target to open an InlineDialog. This will be a <button> unless
         * the `href` prop is passed, which will use an <a> element.
         *
         * @param {string} dialogId - The id of the InlineDialog this trigger controls
         * @param {React.children} children - The HTML contents for this trigger
         * @param {string} [className] - Classes to be added to the trigger
         * @param {string} [href] - The link for this trigger
         */

        var InlineDialogTrigger = exports.InlineDialogTrigger = function (_Component) {
            _inherits(InlineDialogTrigger, _Component);

            function InlineDialogTrigger(props) {
                _classCallCheck(this, InlineDialogTrigger);

                var _this = _possibleConstructorReturn(this, Object.getPrototypeOf(InlineDialogTrigger).call(this, props));

                _this.elementType = 'button';

                _this.triggerProps = {
                    'aria-controls': props.dialogId,
                    'aria-haspopup': true,
                    'className': (0, _classnames2.default)('aui-button', props.className),
                    'data-aui-trigger': true,
                    'role': 'button',
                    'title': props.title
                };

                if (props.href) {
                    _this.triggerProps = _extends({}, _this.triggerProps, {
                        className: props.className,
                        href: props.href,
                        tabIndex: '0'
                    });
                    _this.elementType = 'a';
                }
                return _this;
            }

            _createClass(InlineDialogTrigger, [{
                key: 'render',
                value: function render() {
                    return _react2.default.createElement(this.elementType, this.triggerProps, this.props.children);
                }
            }]);

            return InlineDialogTrigger;
        }(_react.Component);

        InlineDialogTrigger.defaultProps = triggerDefaultProps;
        InlineDialogTrigger.propTypes = triggerPropTypes;

        /**
         * Creates an Inline Dialog.
         *
         * @param {Object} props - Component properties
         * @param {string} props.id - The id of the dialog element. This must match the trigger id
         * @param {React.children} props.children - The HTML contents for this dialog
         * @param {string} [props.className] - Classes to be added to the dialog
         * @param {string} [props.alignment] - The alignment of this dialog.
         * @returns {ReactElement}
         *     See https://docs.atlassian.com/aui/latest/docs/inline-dialog.html#api-reference-alignment
         */
        var InlineDialog = function InlineDialog(props) {
            return _react2.default.createElement(
                _component2.default,
                {
                    id: props.id,
                    markup: '<aui-inline-dialog\n                        id="' + props.id + '"\n                        class="' + props.className + '"\n                        alignment="' + props.alignment + '"\n                     ></aui-inline-dialog>',
                    containerSelector: '#' + props.id + ' .aui-inline-dialog-contents'
                },
                props.children
            );
        };

        InlineDialog.defaultProps = dialogDefaultProps;
        InlineDialog.propTypes = dialogPropTypes;

        exports.default = InlineDialog;
    }
);