define(
    'bitbucket/internal/bbui/reducers/pull-request-can-merge',
    ['exports', 'module', 'lodash', '../actions/pull-request', '../pull-request-header/actions', '../utils/create-reducer', '../utils/merge-state-with-rollback'],
    function (exports, module, _lodash, _actionsPullRequest, _pullRequestHeaderActions, _utilsCreateReducer, _utilsMergeStateWithRollback) {
        'use strict';

        var _createReducer;

        var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

        function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

        function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

        var _2 = _interopRequireDefault(_lodash);

        var _createReducer2 = _interopRequireDefault(_utilsCreateReducer);

        var _mergeWithRollback = _interopRequireDefault(_utilsMergeStateWithRollback);

        var defaultState = {
            canMerge: false,
            conflicted: null,
            vetoes: null,
            properties: null,
            isChecking: false,
            showDialog: false
        };

        module.exports = (0, _createReducer2['default'])(defaultState, (_createReducer = {}, _defineProperty(_createReducer, _actionsPullRequest.PR_CHECK_MERGEABILITY, function (state, action) {
            return (0, _mergeWithRollback['default'])(state, action, {
                forward: function forward() {
                    return {
                        isChecking: true
                    };
                },
                commit: function commit() {
                    return _extends({}, action.payload, {
                        isChecking: false
                    });
                }
            });
        }), _defineProperty(_createReducer, _pullRequestHeaderActions.PR_SHOW_MERGE_ERRORS, function (state, action) {
            return _2['default'].assign({}, state, {
                showDialog: true
            });
        }), _defineProperty(_createReducer, _pullRequestHeaderActions.PR_HIDE_MERGE_ERRORS, function (state, action) {
            return _2['default'].assign({}, state, {
                showDialog: false
            });
        }), _createReducer));
    }
);