define(
    'bitbucket/internal/bbui/list-and-detail-view',
    ['exports', 'module', 'jquery', 'lodash', './widget'],
    function (exports, module, _jquery, _lodash, _widget) {
        'use strict';

        var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

        var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

        function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

        function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

        function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

        var _$ = _interopRequireDefault(_jquery);

        var _2 = _interopRequireDefault(_lodash);

        var _Widget2 = _interopRequireDefault(_widget);

        var ListAndDetailView = (function (_Widget) {
            _inherits(ListAndDetailView, _Widget);

            /**
             * @callback selectionCallback
             * @param {jQuery} $listItem - the element that was invoked
             * @param {jQuery} $listView - the control's list view
             * @param {jQuery} $detailView - the control's detail view
             * @param {Event} e - the click event object
             */

            /**
             * @param {HTMLElement|jQuery} el - The element to use as a container for this ListAndDetailView
             * @param {object} options - options for this ListAndDetailView
             * @param {selectionCallback?} options.selectHandler - invoked when an item in the list is clicked
             * @param {string?} options.selectedClass - CSS class name that is applied to selected list items
             * @param {boolean?} options.selectFirstOnInit - select the first item in the list on init
             * @param {string?} options.detailContent - HTML string that is injected into the detail/content view
             * @param {string?} options.listContent - HTML string that is is injected into the list view
             */

            function ListAndDetailView(el, options) {
                _classCallCheck(this, ListAndDetailView);

                _get(Object.getPrototypeOf(ListAndDetailView.prototype), 'constructor', this).call(this, options);

                this.keycodes = {
                    j: 74,
                    k: 75
                };

                this.$el = (0, _$['default'])(el);
                this.$el.html(bitbucket.internal.component.listAndDetailView.main({
                    listContent: options.listContent || '',
                    detailContent: options.detailContent || ''
                }));
                this.$listView = this.$el.find('.list-view');
                this.$detailView = this.$el.find('.detail-view');
                this.selectHandler = options.selectHandler;

                this.bindShortcuts();
                this.$listView.on('click', this.options.listItemTag, this._itemClickHandler);
                this._maybeSelectFirst();
            }

            _createClass(ListAndDetailView, [{
                key: 'destroy',
                value: function destroy() {
                    _get(Object.getPrototypeOf(ListAndDetailView.prototype), 'destroy', this).call(this);
                    this.unbindShortcuts();
                    this.$el.empty();
                }
            }, {
                key: '_itemClickHandler',
                value: function _itemClickHandler(e) {
                    var selectedClass = this.options.selectedClass;
                    this.$listView.find('li.' + selectedClass).removeClass(selectedClass);
                    var $listItem = (0, _$['default'])(e.currentTarget).addClass(selectedClass);
                    this.selectHandler($listItem, this.$listView, this.$detailView, e);
                }
            }, {
                key: '_maybeSelectFirst',
                value: function _maybeSelectFirst() {
                    if (this.options.selectFirstOnInit) {
                        this.$listView.find(this.options.listItemTag + ':first').click();
                    }
                }
            }, {
                key: '_shortcutHandler',
                value: function _shortcutHandler(e) {
                    var $selected = this.$listView.find(this.options.listItemTag + '.' + this.options.selectedClass);
                    var $target = undefined;
                    if (e.which === this.keycodes.j) {
                        $target = $selected.next(this.options.listItemTag);
                    } else if (e.which === this.keycodes.k) {
                        $target = $selected.prev(this.options.listItemTag);
                    } else {
                        return;
                    }

                    $target.click().find('a').focus().blur(); // Scroll into view if necessary. Will only scroll if there is an <a>
                }
            }, {
                key: 'bindShortcuts',
                value: function bindShortcuts() {
                    (0, _$['default'])(document).on('keydown', this._shortcutHandler);
                }
            }, {
                key: 'unbindShortcuts',
                value: function unbindShortcuts() {
                    (0, _$['default'])(document).off('keydown', this._shortcutHandler);
                }

                /**
                 * Transitions and removes the specified item from the listView.
                 *
                 * @param {jQuery} $item  - item to remove
                 * @param {string} selector - jQuery selector of next/prev item to click
                 * @returns {Promise} a jQuery promise that completes when the item has been removed
                 */
            }, {
                key: 'removeItem',
                value: function removeItem($item, selector) {
                    var deferred = _$['default'].Deferred();

                    function _removeItem() {
                        $item.remove();
                        deferred.resolve();
                    }

                    $item.addClass('offScreen').one('transitionend', _removeItem);

                    if ($item.next(selector).length) {
                        $item.next(selector).click();
                    } else if ($item.prev(selector).length) {
                        $item.prev(selector).click();
                    } else {
                        // No more items in the list.
                        this.$detailView.empty();
                    }
                    return deferred.promise();
                }

                /**
                 * Transitions and adds the specified item to the listView.
                 *
                 * @param {jQuery} $item - to be added
                 * @param {jQuery?} $beforeElement - element before which to insert the specified $item.
                 *                 If not supplied, the element will be appended to $listView.
                 * @param {boolean?} select - true, if the added item should be selected, false otherwise
                 */
            }, {
                key: 'addItem',
                value: function addItem($item, $beforeElement, select) {
                    $item.addClass('offScreen');
                    if ($beforeElement) {
                        $item.insertBefore($beforeElement);
                    } else {
                        $item.appendTo(this.$listView);
                    }
                    $item.offset(); // Ensure the browser paints the item before the transition.
                    $item.removeClass('offScreen');
                    if (select) {
                        $item.click();
                    }
                }
            }]);

            return ListAndDetailView;
        })(_Widget2['default']);

        module.exports = ListAndDetailView;

        ListAndDetailView.defaults = {
            selectedClass: 'selected-item',
            selectFirstOnInit: false,
            listItemTag: 'li',
            selectHandler: _2['default'].noop
        };
    }
);