define(
    'bitbucket/internal/bbui/ref-label',
    ['exports', 'module', 'react', './aui-react/avatar'],
    function (exports, module, _react, _auiReactAvatar) {
        'use strict';

        function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

        var _React = _interopRequireDefault(_react);

        var propTypes = {
            scmRef: _React['default'].PropTypes.any.isRequired,
            repository: _React['default'].PropTypes.any,
            title: _React['default'].PropTypes.string,
            accessibilityText: _React['default'].PropTypes.string
        };

        var RefLabel = function RefLabel(props) {
            var ref = props.scmRef;
            var repo = props.repository;
            var accessibilityText = props.accessibilityText || AJS.I18n.getText('refLabel.branch.ariaLabel', ref.display_id);

            return _React['default'].createElement(
                'span',
                { className: 'ref-label', title: props.title },
                repo && _React['default'].createElement(
                    'span',
                    { className: 'repository' },
                    repo.project && _React['default'].createElement(_auiReactAvatar.ProjectAvatar, { size: 'xsmall', project: repo.project }),
                    _React['default'].createElement(
                        'span',
                        { className: 'name' },
                        repo.name
                    )
                ),
                _React['default'].createElement(
                    'span',
                    { className: "ref " + (ref.type || 'branch') },
                    _React['default'].createElement(
                        'span',
                        { className: 'name', 'aria-label': accessibilityText },
                        ref.display_id
                    )
                )
            );
        };

        RefLabel.propTypes = propTypes;

        module.exports = RefLabel;
    }
);