define(
    'bitbucket/internal/bbui/pull-request-header/components/merge',
    ['exports', 'module', 'react', 'jquery', 'lodash', '../../aui-react/inline-dialog', '../../models', './merge-button', './merge-help-dialog', './merge-instructions'],
    function (exports, module, _react, _jquery, _lodash, _auiReactInlineDialog, _models, _mergeButton, _mergeHelpDialog, _mergeInstructions) {
        'use strict';

        var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

        var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

        function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

        function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

        function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

        var _React = _interopRequireDefault(_react);

        var _$ = _interopRequireDefault(_jquery);

        var _2 = _interopRequireDefault(_lodash);

        var _InlineDialog = _interopRequireDefault(_auiReactInlineDialog);

        var _MergeButton = _interopRequireDefault(_mergeButton);

        var _MergeHelpDialog = _interopRequireDefault(_mergeHelpDialog);

        var _MergeInstructions = _interopRequireDefault(_mergeInstructions);

        var REASONABLE_DELAY = 50;
        var MERGE_WARNING_DIALOG_ID = 'merge-warning-inline-dialog';

        var Merge = (function (_Component) {
            _inherits(Merge, _Component);

            _createClass(Merge, null, [{
                key: 'propTypes',
                get: function get() {
                    return {
                        conditions: _react.PropTypes.object.isRequired,
                        mergeHelp: _react.PropTypes.object,
                        onMergeClick: _react.PropTypes.func.isRequired,
                        onMergeHelpDialogClose: _react.PropTypes.func,
                        pullRequest: _react.PropTypes.object.isRequired,
                        showMergeHelpDialog: _react.PropTypes.bool
                    };
                }
            }]);

            function Merge() {
                _classCallCheck(this, Merge);

                for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
                    args[_key] = arguments[_key];
                }

                _get(Object.getPrototypeOf(Merge.prototype), 'constructor', this).apply(this, args);
                this.state = {};
            }

            _createClass(Merge, [{
                key: 'componentDidMount',
                value: function componentDidMount() {
                    var _this = this;

                    this.mergeWarningDialog = document.getElementById(MERGE_WARNING_DIALOG_ID);

                    this.throttledWarningDialogHide = _2['default'].throttle(function () {
                        if (_this.mergeWarningDialog) {
                            _this.mergeWarningDialog.open = false;
                        }
                    }, REASONABLE_DELAY);
                    (0, _$['default'])(window).on('scroll resize', this.throttledWarningDialogHide);

                    // the warning dialog can also be shown/hidden outside of its trigger so update state
                    // by using the events triggered on the dialog.
                    this.onToggleMergeWarningDialog = function (e) {
                        _this.setState({ mergeWarningDialogOpen: e.type === 'aui-show' ? true : false });
                    };
                    (0, _$['default'])(this.mergeWarningDialog).on('aui-show aui-hide', this.onToggleMergeWarningDialog);
                }
            }, {
                key: 'componentWillReceiveProps',
                value: function componentWillReceiveProps(nextProps) {
                    this.setState({ mergeHelpDialogShowing: nextProps.showMergeHelpDialog });
                }
            }, {
                key: 'componentWillUnmount',
                value: function componentWillUnmount() {
                    (0, _$['default'])(window).off('scroll resize', this.throttledWarningDialogHide);
                    (0, _$['default'])(this.mergeWarningDialog).off('aui-show aui-hide', this.onToggleMergeWarningDialog);
                }
            }, {
                key: 'onHideMergeHelpDialog',
                value: function onHideMergeHelpDialog() {
                    this.extendedMergeHelpContent = '';
                    this.setState({ mergeHelpDialogShowing: false });
                    if (this.props.onMergeHelpDialogClose) {
                        this.props.onMergeHelpDialogClose();
                    }
                }
            }, {
                key: 'onMergeWarningClick',
                value: function onMergeWarningClick() {
                    this.toggleMergeWarningDialog();
                }
            }, {
                key: 'toggleMergeWarningDialog',
                value: function toggleMergeWarningDialog(open) {
                    if (open == null) {
                        open = !this.mergeWarningDialog.open;
                    }
                    this.mergeWarningDialog.open = open;
                }

                /**
                 * @param {ReactElement|Node} content - the content
                 */
            }, {
                key: 'showExtendedMergeHelp',
                value: function showExtendedMergeHelp() {
                    this.setState({ mergeHelpDialogShowing: true });
                }
            }, {
                key: 'render',
                value: function render() {
                    var _this2 = this;

                    var pullRequest = this.props.pullRequest;

                    if (pullRequest.state === _models.PullRequestState.OPEN && pullRequest.mergeable && this.props.conditions.canMerge) {

                        var vetoes = pullRequest.mergeable.vetoes && [].concat(pullRequest.mergeable.vetoes);
                        if (pullRequest.mergeable.conflicted) {
                            // add the conflicted veto as the first item
                            vetoes.unshift({
                                detailedMessage: AJS.I18n.getText('bitbucket.component.pull.request.merge.conflict.detail'),
                                isConflictVeto: true
                            });
                        }

                        var mergeWarningDialogProps = {
                            "aria-controls": MERGE_WARNING_DIALOG_ID,
                            "aria-haspopup": true
                        };

                        var mergeHelpDialog = undefined;
                        if (this.state.mergeHelpDialogShowing) {
                            var stability = this.props.mergeHelp && this.props.mergeHelp.stability;
                            var isAutoMergeConflict = this.props.mergeHelp && this.props.mergeHelp.isAutoMergeConflict;
                            mergeHelpDialog = _React['default'].createElement(
                                _MergeHelpDialog['default'],
                                {
                                    id: 'extended-merge-help-dialog',
                                    onHide: function () {
                                        return _this2.onHideMergeHelpDialog();
                                    },
                                    title: AJS.I18n.getText('bitbucket.component.pull.request.merge.help.header')
                                },
                                _React['default'].createElement(_MergeInstructions['default'], {
                                    pullRequest: pullRequest,
                                    stability: stability,
                                    isAutoMergeConflict: isAutoMergeConflict
                                })
                            );
                        }

                        var mergeWarningInlineDialog = _React['default'].createElement(
                            _InlineDialog['default'],
                            {
                                key: 'merge-warning-dialog',
                                id: MERGE_WARNING_DIALOG_ID,
                                alignment: 'bottom'
                            },
                            _React['default'].createElement(
                                'div',
                                { className: 'merge-warning-content' },
                                _React['default'].createElement(
                                    'h6',
                                    null,
                                    AJS.I18n.getText('bitbucket.component.pull.request.merge.warnings.title')
                                ),
                                _React['default'].createElement(
                                    'p',
                                    null,
                                    AJS.I18n.getText('bitbucket.component.pull.request.merge.warnings.info', vetoes && vetoes.length)
                                ),
                                _React['default'].createElement(
                                    'ul',
                                    { className: 'aui-list-truncate' },
                                    vetoes && vetoes.map(function (veto, i) {
                                        var moreInfoButton = veto.isConflictVeto === undefined ? null : _React['default'].createElement(
                                            'button',
                                            {
                                                className: 'aui-button aui-button-link more-info',
                                                onClick: function () {
                                                    return _this2.showExtendedMergeHelp();
                                                }
                                            },
                                            AJS.I18n.getText('bitbucket.component.pull.request.merge.warnings.more.button')
                                        );
                                        return _React['default'].createElement(
                                            'li',
                                            { key: 'merge-issue-' + i },
                                            _React['default'].createElement(
                                                'span',
                                                { className: 'message' },
                                                _React['default'].createElement('span', { className: 'aui-icon aui-icon-small aui-iconfont-warning' }),
                                                veto.detailedMessage
                                            ),
                                            moreInfoButton
                                        );
                                    })
                                )
                            )
                        );

                        return _React['default'].createElement(
                            'div',
                            null,
                            _React['default'].createElement(_MergeButton['default'], {
                                onMergeClick: this.props.onMergeClick,
                                onMergeWarningClick: function () {
                                    return _this2.onMergeWarningClick();
                                },
                                mergeable: pullRequest.mergeable,
                                conflicted: pullRequest.mergeable.conflicted,
                                vetoes: pullRequest.mergeable.vetoes,
                                extraButtonProps: mergeWarningDialogProps,
                                tooltipVisibility: !this.state.mergeWarningDialogOpen
                            }),
                            mergeWarningInlineDialog,
                            mergeHelpDialog
                        );
                    }

                    return null;
                }
            }]);

            return Merge;
        })(_react.Component);

        module.exports = Merge;
    }
);