define(
    'bitbucket/internal/bbui/avatar-list',
    ['exports', 'module', 'jquery'],
    function (exports, module, _jquery) {
        'use strict';

        function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

        var _$ = _interopRequireDefault(_jquery);

        var approvalOrder = {
            APPROVED: 1,
            NEEDS_WORK: 2,
            UNAPPROVED: 3
        };

        var currentUser = undefined;

        module.exports = {
            updateApproval: function updateApproval(listEl, participant) {
                var $avatars = (0, _$['default'])(listEl).find('.user-avatar[data-username="' + participant.getUser().getName() + '"]');
                $avatars.toggleClass('badge-hidden', !participant.getApproved());
            },
            sortParticipants: function sortParticipants(participants) {
                currentUser = currentUser || (0, _$['default'])('[data-logged-in-reviewer]').attr('data-logged-in-reviewer');
                var loggedInReviewer = currentUser && JSON.parse(currentUser);
                var loggedInReviewerName = loggedInReviewer && loggedInReviewer.name;

                function compare(a, b) {
                    return approvalOrder[a.state] - approvalOrder[b.state] || (a.user.name === loggedInReviewerName ? -1 : 0 || (b.user.name === loggedInReviewerName ? 1 : a.user.display_name.localeCompare(b.user.display_name)));
                }
                return participants.sort(compare);
            }
        };
    }
);