define(
    'bitbucket/internal/bbui/pull-request-list-table/components/summary',
    ['exports', 'module', 'react', 'bitbucket/internal/impl/urls', '../../aui-react/icon', '../../ref-label', '../../time'],
    function (exports, module, _react, _bitbucketInternalImplUrls, _auiReactIcon, _refLabel, _time) {
        'use strict';

        var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

        var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

        function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

        function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

        function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

        var _React = _interopRequireDefault(_react);

        var _urls = _interopRequireDefault(_bitbucketInternalImplUrls);

        var _Icon = _interopRequireDefault(_auiReactIcon);

        var _RefLabel = _interopRequireDefault(_refLabel);

        var propTypes = {
            pullRequest: _react.PropTypes.object.isRequired
        };

        var customMapping = {
            aMomentAgo: function aMomentAgo() {
                return AJS.I18n.getText('bitbucket.pull.request.updated.date.format.a.moment.ago');
            },
            oneMinuteAgo: function oneMinuteAgo() {
                return AJS.I18n.getText('bitbucket.pull.request.updated.date.format.one.minute.ago');
            },
            xMinutesAgo: function xMinutesAgo(param) {
                return AJS.I18n.getText('bitbucket.pull.request.updated.date.format.x.minutes.ago', param);
            },
            oneHourAgo: function oneHourAgo() {
                return AJS.I18n.getText('bitbucket.pull.request.updated.date.format.one.hour.ago');
            },
            xHoursAgo: function xHoursAgo(param) {
                return AJS.I18n.getText('bitbucket.pull.request.updated.date.format.x.hours.ago', param);
            },
            oneDayAgo: function oneDayAgo() {
                return AJS.I18n.getText('bitbucket.pull.request.updated.date.format.one.day.ago');
            },
            xDaysAgo: function xDaysAgo(param) {
                return AJS.I18n.getText('bitbucket.pull.request.updated.date.format.x.days.ago', param);
            },
            oneWeekAgo: function oneWeekAgo() {
                return AJS.I18n.getText('bitbucket.pull.request.updated.date.format.one.week.ago');
            },
            defaultType: function defaultType(param) {
                return AJS.I18n.getText('bitbucket.pull.request.updated.date.format.absolute', param);
            }
        };

        var Summary = (function (_Component) {
            _inherits(Summary, _Component);

            function Summary() {
                _classCallCheck(this, Summary);

                _get(Object.getPrototypeOf(Summary.prototype), 'constructor', this).apply(this, arguments);
            }

            _createClass(Summary, [{
                key: 'shouldComponentUpdate',
                value: function shouldComponentUpdate(newProps) {
                    return this.props.pullRequest.id !== newProps.pullRequest.id || this.props.pullRequest.title !== newProps.pullRequest.title || this.props.pullRequest.to_ref.id !== newProps.pullRequest.to_ref.id || this.props.pullRequest.updated_date !== newProps.pullRequest.updated_date;
                }
            }, {
                key: 'render',
                value: function render() {
                    var props = this.props;
                    var pullRequest = props.pullRequest;

                    return _React['default'].createElement(
                        'td',
                        { className: 'summary' },
                        _React['default'].createElement(
                            'div',
                            { className: 'title-and-target-branch' },
                            _React['default'].createElement(
                                'a',
                                { className: 'pull-request-title',
                                    title: pullRequest.title,
                                    href: _urls['default'].pullRequest(pullRequest)
                                },
                                pullRequest.title
                            ),
                            _React['default'].createElement(_Icon['default'], { size: 'small', icon: 'devtools-arrow-right' }),
                            _React['default'].createElement(
                                'span',
                                { className: 'pull-request-target-branch' },
                                _React['default'].createElement(_RefLabel['default'], { scmRef: pullRequest.to_ref })
                            )
                        ),
                        _React['default'].createElement(
                            'div',
                            { className: 'pr-author-number-and-timestamp' },
                            _React['default'].createElement(
                                'span',
                                null,
                                pullRequest.author.user.display_name,
                                ' - #',
                                pullRequest.id,
                                ', '
                            ),
                            _React['default'].createElement(
                                'time',
                                {
                                    title: (0, _time.format)(pullRequest.updated_date, 'full'),
                                    dateTime: (0, _time.format)(pullRequest.updated_date, 'timestamp')
                                },
                                (0, _time.format)(pullRequest.updated_date, 'shortAge', customMapping)
                            )
                        )
                    );
                }
            }]);

            return Summary;
        })(_react.Component);

        var headerPropTypes = {
            colSpan: _react.PropTypes.number
        };

        var Header = function Header(props) {
            return _React['default'].createElement(
                'th',
                { className: 'summary', scope: 'col', colSpan: props.colSpan },
                AJS.I18n.getText('bitbucket.pull.request.table.title.summary')
            );
        };

        Header.propTypes = headerPropTypes;
        Summary.propTypes = propTypes;

        Summary.Header = Header;

        module.exports = Summary;
    }
);