define(
    'bitbucket/internal/bbui/pull-request-header',
    ['exports', 'module', 'react', 'classnames', 'lodash', './aui-react/avatar', './branch-from-to', './models', './reviewer-avatar-list', './reviewer-status', './pull-request-header/components/merge', './pull-request-header/components/pull-request-more', './pull-request-header/components/reopen-button'],
    function (exports, module, _react, _classnames, _lodash, _auiReactAvatar, _branchFromTo, _models, _reviewerAvatarList, _reviewerStatus, _componentsMerge, _componentsPullRequestMore, _componentsReopenButton) {
        'use strict';

        var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

        var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

        function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

        function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

        function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

        function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

        var _React = _interopRequireDefault(_react);

        var _classNames = _interopRequireDefault(_classnames);

        var _2 = _interopRequireDefault(_lodash);

        var _Avatar = _interopRequireDefault(_auiReactAvatar);

        var _BranchFromTo = _interopRequireDefault(_branchFromTo);

        var _ReviewerAvatarList = _interopRequireDefault(_reviewerAvatarList);

        var _ReviewerStatus = _interopRequireDefault(_reviewerStatus);

        var _Merge = _interopRequireDefault(_componentsMerge);

        var _PullRequestMore = _interopRequireDefault(_componentsPullRequestMore);

        var _ReOpenButton = _interopRequireDefault(_componentsReopenButton);

        var propTypes = {
            conditions: _react.PropTypes.objectOf(_react.PropTypes.bool),
            mergeHelp: _react.PropTypes.object,
            currentUserAsReviewer: _react.PropTypes.object,
            currentUserIsWatching: _react.PropTypes.bool,
            currentUserStatus: _react.PropTypes.oneOf(_2['default'].values(_models.ApprovalState)),
            onMergeClick: _react.PropTypes.func.isRequired,
            onReOpenClick: _react.PropTypes.func.isRequired,
            onMergeHelpDialogClose: _react.PropTypes.func,
            onMoreAction: _react.PropTypes.func.isRequired,
            onSelfClick: _react.PropTypes.func.isRequired,
            onStatusClick: _react.PropTypes.func.isRequired,
            pullRequest: _react.PropTypes.object.isRequired,
            permissionToReview: _react.PropTypes.bool.isRequired,
            showMergeHelpDialog: _react.PropTypes.bool
        };

        var REVIEWERS_MAX_OPEN = 4;

        var PullRequestHeader = (function (_Component) {
            _inherits(PullRequestHeader, _Component);

            function PullRequestHeader() {
                _classCallCheck(this, PullRequestHeader);

                _get(Object.getPrototypeOf(PullRequestHeader.prototype), 'constructor', this).apply(this, arguments);
            }

            _createClass(PullRequestHeader, [{
                key: 'pullRequestStateReadable',
                value: function pullRequestStateReadable(state) {
                    var _stateToReadable;

                    var stateToReadable = (_stateToReadable = {}, _defineProperty(_stateToReadable, _models.PullRequestState.OPEN, AJS.I18n.getText('bitbucket.component.pull.request.list.state.open')), _defineProperty(_stateToReadable, _models.PullRequestState.DECLINED, AJS.I18n.getText('bitbucket.component.pull.request.list.state.declined')), _defineProperty(_stateToReadable, _models.PullRequestState.MERGED, AJS.I18n.getText('bitbucket.component.pull.request.list.state.merged')), _stateToReadable);
                    return stateToReadable.hasOwnProperty(state) ? stateToReadable[state] : '';
                }
            }, {
                key: 'render',
                value: function render() {
                    var pullRequest = this.props.pullRequest;

                    var pullRequestIsOpen = pullRequest.state === _models.PullRequestState.OPEN;
                    var reOpenButton = undefined;
                    var reviewerStatus = undefined;

                    if (pullRequest.state === _models.PullRequestState.DECLINED && this.props.conditions.canEdit) {
                        reOpenButton = _React['default'].createElement(_ReOpenButton['default'], {
                            onReOpenClick: this.props.onReOpenClick
                        });
                    }

                    if (pullRequestIsOpen) {
                        reviewerStatus = _React['default'].createElement(_ReviewerStatus['default'], {
                            currentUserAsReviewer: this.props.currentUserAsReviewer,
                            onStatusClick: this.props.onStatusClick,
                            status: this.props.currentUserStatus
                        });
                    }

                    return _React['default'].createElement(
                        'div',
                        { className: 'pull-request-header' },
                        _React['default'].createElement(
                            'div',
                            { className: 'flexible' },
                            _React['default'].createElement(
                                'div',
                                { className: 'pull-request-metadata' },
                                _React['default'].createElement(_Avatar['default'], {
                                    className: 'author',
                                    person: pullRequest.author,
                                    withName: true,
                                    withLink: true
                                }),
                                _React['default'].createElement(_BranchFromTo['default'], {
                                    fromRef: pullRequest.from_ref,
                                    toRef: pullRequest.to_ref
                                }),
                                _React['default'].createElement('div', { className: 'divider' }),
                                _React['default'].createElement(
                                    'div',
                                    { className: (0, _classNames['default'])('status', 'aui-lozenge', {
                                            'aui-lozenge-complete': pullRequest.state === _models.PullRequestState.OPEN,
                                            'aui-lozenge-error': pullRequest.state === _models.PullRequestState.DECLINED,
                                            'aui-lozenge-success': pullRequest.state === _models.PullRequestState.MERGED
                                        })
                                    },
                                    this.pullRequestStateReadable(pullRequest.state)
                                )
                            ),
                            _React['default'].createElement(
                                'div',
                                { className: (0, _classNames['default'])('pull-request-actions', { pullRequestIsOpen: pullRequestIsOpen }) },
                                _React['default'].createElement(_ReviewerAvatarList['default'], {
                                    reviewers: pullRequest.reviewers,
                                    menuId: 'overflow-reviewers',
                                    triggerClass: 'overflow-reviewers-trigger',
                                    maxOpen: REVIEWERS_MAX_OPEN,
                                    avatarSize: 'small',
                                    reverse: true,
                                    onSelfClick: this.props.onSelfClick,
                                    currentUserAsReviewer: this.props.currentUserAsReviewer,
                                    isWatching: this.props.currentUserIsWatching,
                                    permissionToReview: this.props.permissionToReview,
                                    pullRequestIsOpen: pullRequestIsOpen
                                }),
                                reviewerStatus,
                                _React['default'].createElement(_Merge['default'], {
                                    conditions: this.props.conditions,
                                    mergeHelp: this.props.mergeHelp,
                                    onMergeClick: this.props.onMergeClick,
                                    onMergeHelpDialogClose: this.props.onMergeHelpDialogClose,
                                    pullRequest: pullRequest,
                                    showMergeHelpDialog: this.props.showMergeHelpDialog
                                }),
                                reOpenButton,
                                _React['default'].createElement(_PullRequestMore['default'], {
                                    onMoreAction: this.props.onMoreAction,
                                    isWatching: this.props.currentUserIsWatching,
                                    conditions: this.props.conditions,
                                    pullRequest: pullRequest
                                })
                            )
                        ),
                        _React['default'].createElement(
                            'h2',
                            null,
                            pullRequest.title
                        )
                    );
                }
            }]);

            return PullRequestHeader;
        })(_react.Component);

        PullRequestHeader.propTypes = propTypes;

        module.exports = PullRequestHeader;
    }
);