define(
    'bitbucket/internal/bbui/filter-bar/legacy',
    ['exports', 'module', 'aui', 'jquery', 'lodash', 'internal/util/navigator', '../widget'],
    function (exports, module, _aui, _jquery, _lodash, _internalUtilNavigator, _widget) {
        'use strict';

        var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

        var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

        function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

        function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

        function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

        var _AJS = _interopRequireDefault(_aui);

        var _$ = _interopRequireDefault(_jquery);

        var _2 = _interopRequireDefault(_lodash);

        var _navigatorUtil = _interopRequireDefault(_internalUtilNavigator);

        var _Widget2 = _interopRequireDefault(_widget);

        /**
         * The type of filter to show.
         * @enum {string} FilterType
         */
        var FilterType = {
            SELECT: 'SELECT', // a dropdown menu - loaded synchronously or via AJAX
            TOGGLE: 'TOGGLE', // a toggle button - on or off
            MULTISELECT: 'MULTISELECT' };

        /**
         * @class FilterDescriptor
         * @property {FilterType} type - The type of this filter
         * @property {string} id - The HTML ID for the filter, as well as the key under which the filter's state will be returned. Must be unique on the page.
         * @property {string} text - The text of this filter
         * @param {FilterDescriptor[]} filters - The filters to validate
         */
        // a dropdown menu allowing for multiple selections
        function validateFilters(filters) {
            var filtersById = {};
            filters.forEach(function (filter) {
                ['type', 'id', 'text'].forEach(function (prop) {
                    if (typeof filter[prop] !== 'string') {
                        throw new Error('Every filter needs a ' + prop);
                    }
                });
                if (filter.type === 'SELECT') {
                    var menu = filter.menu;
                    if (!menu) {
                        throw new Error('select filters need a menu configuration.');
                    }
                    if (!menu.items) {
                        if (!menu.dataProvider || !menu.placeholder) {
                            if (!menu.dataProvider && !menu.placeholder) {
                                throw new Error('select filters need a menu with either hardcoded items or dataProvider and placeholder.');
                            }
                            throw new Error("When items aren't provided, dataProvider and placeholder must be.");
                        }
                    } else if (menu.dataProvider) {
                        throw new Error('items is mutually exclusive with dataProvider.');
                    }
                }
                if (filter.type === 'MULTISELECT' && !_2['default'].has(filter, 'menu.items')) {
                    throw new Error('multiselect filters need a menu with items.');
                }
                if (filtersById[filter.id]) {
                    throw new Error('duplicated ID ' + filter.id);
                }
                filtersById[filter.id] = filter;
            });
        }

        function initToggle(filter, $filter) {
            $filter.click(function () {
                $filter.attr('aria-pressed', $filter.attr('aria-pressed') && $filter.attr('aria-pressed') !== 'false' ? null : 'true');
                $filter.trigger('change');
            });
        }

        function initStaticSelect(filter, $filter) {
            var defaults = {
                minimumResultsForSearch: -1 };
            // don't show the search box.
            var overrides = {};
            $filter.auiSelect2(_2['default'].extend(defaults, filter.menu, overrides));
        }

        function initAsyncSelect(filter, $filter) {
            var menu = filter.menu;
            var dataProvider = menu.dataProvider;
            var $searchBoxSpinner = (0, _$['default'])(bitbucket.internal.component.filterBar.loadMore());
            dataProvider.__test = 0;
            var defaults = {
                minimumInputLength: 0,
                minimumResultsForSearch: 0,
                dropdownAutoWidth: true,
                formatSearching: function formatSearching() {
                    return _AJS['default'].I18n.getText('bitbucket.component.filter.bar.searching');
                },
                formatNoMatches: function formatNoMatches() {
                    return _AJS['default'].I18n.getText('bitbucket.component.filter.bar.nomatches');
                }
            };
            var overrides = {
                allowClear: true,
                containerCssClass: ('filter-bar-async ' + (menu.containerCssClass || '')).trim(),
                dropdownCssClass: ('filter-bar-async filter-bar-dropdown-' + filter.id + ' ' + (menu.dropdownCssClass || '')).trim(),
                query: function query(_query) {
                    dataProvider.setFilter('term', _query.term);

                    if (_query.page <= 1) {
                        // first page for this search.
                        $searchBoxSpinner.spin();
                        dataProvider.reset();
                    }

                    var _ref = dataProvider.fetchNext ? {
                        more: function more() {
                            return !dataProvider.reachedEnd;
                        },
                        promise: dataProvider.fetchNext()
                    } : {
                        more: function more() {
                            return false;
                        },
                        promise: dataProvider.fetch()
                    };

                    var more = _ref.more;
                    var promise = _ref.promise;

                    var $spinner = (0, _$['default'])('.select2-more-results').html(bitbucket.internal.component.filterBar.loadMore());
                    $spinner.spin();

                    promise.then(function (items) {
                        $spinner.spinStop();
                        $searchBoxSpinner.spinStop();
                        _query.callback({
                            context: _query.context,
                            results: menu.transform ? items.map(menu.transform) : items,
                            more: more()
                        });
                    });
                },
                formatLoadMore: function formatLoadMore() {
                    return ' '; // blank out the default text because we're replacing it with the spinner
                },
                ajax: undefined
            };
            $filter.auiSelect2(_2['default'].extend(defaults, menu, overrides));
            $filter.on('select2-opening', function (e) {
                if ($filter.select2('val')) {
                    // if there's a selection, force the clearing of it instead of opening.
                    e.preventDefault();
                    $filter.select2('val', '', true); // clear and trigger change
                }
            });
            if (filter.searchPlaceholder && !_navigatorUtil['default'].isIE()) {
                // IE11 & below will fail - see STASHDEV-10518
                $filter.one('select2-open', function () {
                    // make sure it's filtered by specific dropdown so this only affects the select2 that $filter belongs to
                    (0, _$['default'])('.filter-bar-dropdown-' + filter.id + ' .select2-search > input').attr('placeholder', filter.searchPlaceholder).after($searchBoxSpinner);
                });
            }
        }

        function initMultiSelect(filter, $filter, $filterBar) {
            // Can't simply listen to click events since these elements
            // are keyboard accessible
            $filter.on('aui-dropdown2-item-check aui-dropdown2-item-uncheck', 'aui-item-checkbox', function () {
                // We can't trigger the change event on the filter itself
                // because it lives at the bottom of the body and it
                // won't bubble up
                $filterBar.trigger('change');
            });
        }

        function mapIdsToText(menuItems) {
            return menuItems.reduce(function (acc, item) {
                acc[item.id] = item.text;
                return acc;
            }, {});
        }

        function setDropdownLabel(filter, state, menuItems, initialLabel) {
            var $trigger = (0, _$['default'])('[aria-owns="' + filter + '"], [aria-controls="' + filter + '"]');

            if (!state.length) {
                $trigger.text(initialLabel);
                return;
            }

            var labels = mapIdsToText(menuItems);
            var selectedLabels = state.map(function (s) {
                return labels[s];
            });

            var MAX_ITEMS = 3;
            var triggerLabel = state.length > MAX_ITEMS ? selectedLabels.slice(0, MAX_ITEMS).join(', ') + (', +' + (state.length - MAX_ITEMS)) : selectedLabels.join(', ');

            $trigger.text(triggerLabel);
        }

        var FilterBar = (function (_Widget) {
            _inherits(FilterBar, _Widget);

            /**
             * @param {jQuery|HTMLElement} el - The container element for this FilterBar
             * @param {Object} options - The options for this FilterBar
             */

            function FilterBar(el, options) {
                var _this = this;

                _classCallCheck(this, FilterBar);

                _get(Object.getPrototypeOf(FilterBar.prototype), 'constructor', this).call(this, options);
                validateFilters(options.filters);

                var $filterBar = this._$filterBar = (0, _$['default'])(bitbucket.internal.component.filterBar.main({
                    id: options.id,
                    filters: options.filters.map(function (filter) {
                        if (!filter.menu || !filter.menu.items || !filter.menu.transform) {
                            return filter;
                        }
                        filter = _2['default'].deepClone(filter);
                        filter.menu.items = filter.menu.items.map(filter.menu.transform);
                        return filter;
                    }),
                    query: options.query
                }));

                options.filters.forEach(function (filter) {
                    var $filter = $filterBar.find('#' + filter.id);
                    switch (filter.type) {
                        case FilterType.TOGGLE:
                            initToggle(filter, $filter);
                            break;
                        case FilterType.SELECT:
                            if (filter.menu.items) {
                                // static
                                initStaticSelect(filter, $filter);
                            } else {
                                // data provider
                                initAsyncSelect(filter, $filter);
                            }
                            break;
                        case FilterType.MULTISELECT:
                            initMultiSelect(filter, $filter, $filterBar);
                            break;
                    }
                });

                (0, _$['default'])(el).append($filterBar);

                if (options.query) {
                    (function () {
                        var refreshState = function refreshState(currentVal) {
                            if (currentVal.length > 0) {
                                $searchIcon.hide();
                                $clearIcon.show();
                                $queryInput.addClass('expanded');
                            } else {
                                $clearIcon.hide();
                                $searchIcon.show();
                                if (document.activeElement !== queryInput) {
                                    $queryInput.removeClass('expanded');
                                }
                            }
                        };

                        var $clearIcon = (0, _$['default'])('.query-clear-icon');
                        var $searchIcon = (0, _$['default'])('.query-search-icon');

                        var queryInput = document.getElementById(options.query.id);
                        var $queryInput = (0, _$['default'])(queryInput);
                        var $queryForm = (0, _$['default'])('#query-form');

                        $queryForm.on('submit', function (e) {
                            return e.preventDefault();
                        });

                        $searchIcon.on('click', function () {
                            return $queryInput.focus();
                        });
                        $clearIcon.on('click', function () {
                            $queryInput.val('');
                            $queryInput.trigger('keyup');
                            $queryInput.blur();
                        });
                        $queryInput.on('focus', function () {
                            return $queryInput.addClass('expanded');
                        });
                        $queryInput.on('blur', function () {
                            return refreshState($queryInput.val());
                        });

                        var lastVal = $queryInput.val();

                        refreshState(lastVal);

                        var debouncedChangeTrigger = _2['default'].debounce(function () {
                            return _this.trigger('change');
                        }, options.query.debounce);

                        $queryInput.on('keyup', function () {
                            var currentVal = $queryInput.val();
                            if (currentVal !== lastVal) {
                                refreshState(currentVal);
                                lastVal = currentVal;
                                debouncedChangeTrigger();
                            }
                        });

                        /**
                         * We do not want to trigger a `change` event if the user
                         * hits the 'Enter' key from within the query input.
                         */
                        $filterBar.on('change', function (e) {
                            if (e.target !== queryInput) {
                                _this.trigger('change');
                            }
                        });
                    })();
                } else {
                    $filterBar.on('change', function () {
                        _this.trigger('change');
                    });
                }

                this.on('change', function () {
                    _this.options.filters.filter(function (filter) {
                        return filter.type === FilterType.MULTISELECT;
                    }).forEach(function (filter) {
                        setDropdownLabel(filter.id, _this.state[filter.id], filter.menu.items, filter.text);
                    });
                });
            }

            _createClass(FilterBar, [{
                key: 'state',
                get: function get() {
                    var filters = _2['default'].transform(this.options.filters, function (state, filter) {
                        var $filter = (0, _$['default'])(document.getElementById(filter.id));
                        if (filter.type === FilterType.TOGGLE) {
                            state[filter.id] = !!$filter.attr('aria-pressed') && $filter.attr('aria-pressed') !== 'false';
                        } else if (filter.type === FilterType.SELECT) {
                            state[filter.id] = $filter.val();
                        } else if (filter.type === FilterType.MULTISELECT) {
                            state[filter.id] = $filter.find('aui-item-checkbox[checked]').map(function (i, el) {
                                return el.dataset.value;
                            }).get();
                        }
                    }, {});

                    if (this.options.query) {
                        filters[this.options.query.id] = this._$filterBar.find('#' + this.options.query.id).val();
                    }

                    return filters;
                },
                set: function set(filters) {
                    _2['default'].map(filters, function (state, filter) {
                        var $filter = (0, _$['default'])(document.getElementById(filter));
                        if (!$filter.length) {
                            return;
                        }
                        if ($filter.is('button')) {
                            $filter.attr('aria-pressed', state);
                        } else if ($filter.is('aui-dropdown-menu')) {
                            $filter.find('aui-item-checkbox').each(function (i, el) {
                                var $checkbox = (0, _$['default'])(el);
                                // Check element's value against array of
                                // values in filter state
                                if (state.indexOf($checkbox.attr('data-value')) === -1) {
                                    $checkbox.removeAttr('checked');
                                } else {
                                    $checkbox.attr('checked', true);
                                }
                            });
                        } else {
                            $filter.select2('val', state);
                        }
                    });

                    if (this.options.query) {
                        this._$filterBar.find('#' + this.options.query.id).val(filters[this.options.query.id]);
                    }
                    this.trigger('change');
                }
            }], [{
                key: 'Types',
                get: function get() {
                    return FilterType;
                }
            }]);

            return FilterBar;
        })(_Widget2['default']);

        module.exports = FilterBar;
    }
);