define(
    'bitbucket/internal/bbui/filter-bar/components/async-select',
    ['exports', 'module', 'react', 'classnames', 'jquery', 'lodash', 'react-dom', 'internal/util/navigator', '../../aui-react/spinner', './filter'],
    function (exports, module, _react, _classnames, _jquery, _lodash, _reactDom, _internalUtilNavigator, _auiReactSpinner, _filter) {
        'use strict';

        var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

        var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

        function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

        function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

        function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

        var _React = _interopRequireDefault(_react);

        var _classNames = _interopRequireDefault(_classnames);

        var _$ = _interopRequireDefault(_jquery);

        var _2 = _interopRequireDefault(_lodash);

        var _ReactDOM = _interopRequireDefault(_reactDom);

        var _navigatorUtil = _interopRequireDefault(_internalUtilNavigator);

        var _Spinner = _interopRequireDefault(_auiReactSpinner);

        var _Filter2 = _interopRequireDefault(_filter);

        var AsyncSelect = (function (_Filter) {
            _inherits(AsyncSelect, _Filter);

            _createClass(AsyncSelect, null, [{
                key: 'propTypes',
                get: function get() {
                    return {
                        id: _react.PropTypes.string.isRequired,
                        label: _react.PropTypes.string.isRequired,
                        loading: _react.PropTypes.bool,
                        menu: _react.PropTypes.any,
                        onChange: _react.PropTypes.func,
                        onMoreItemsRequested: _react.PropTypes.func.isRequired,
                        onResetRequested: _react.PropTypes.func.isRequired,
                        onTermChanged: _react.PropTypes.func.isRequired,
                        searchPlaceholder: _react.PropTypes.string,
                        value: _react.PropTypes.string
                    };
                }
            }]);

            function AsyncSelect() {
                _classCallCheck(this, AsyncSelect);

                for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
                    args[_key] = arguments[_key];
                }

                _get(Object.getPrototypeOf(AsyncSelect.prototype), 'constructor', this).apply(this, args);
                this.state = {
                    pendingItems: [],
                    pendingQuery: null,
                    term: '',
                    searchBoxSpinnerContainer: document.createElement('div'),
                    moreResultsEl: null
                };
            }

            _createClass(AsyncSelect, [{
                key: 'componentDidMount',
                value: function componentDidMount() {
                    var _this = this;

                    var defaults = {
                        minimumInputLength: 0,
                        minimumResultsForSearch: 0,
                        dropdownAutoWidth: true,
                        formatSearching: function formatSearching() {
                            return AJS.I18n.getText('bitbucket.component.filter.bar.searching');
                        },
                        formatNoMatches: function formatNoMatches() {
                            return AJS.I18n.getText('bitbucket.component.filter.bar.nomatches');
                        }
                    };
                    var overrides = {
                        allowClear: true,
                        containerCssClass: (0, _classNames['default'])("filter-bar-async", this.props.menu.containerCssClass),
                        dropdownCssClass: (0, _classNames['default'])("filter-bar-async", 'filter-bar-dropdown-' + this.props.id, this.props.menu.dropdownCssClass),
                        query: function query(_query) {
                            if (_this.state.pendingQuery && _query.page === _this.state.pendingQuery.page && _query.term === _this.state.pendingQuery.term) {
                                return; // Select2 is being dumb and calling query multiple times.
                            }

                            if (_query.page <= 1 || _this.state.pendingQuery) {
                                _this.props.onResetRequested(); // make sure the caller knows to start fresh with sending items.
                            }

                            if (_this.state.term !== _query.term) {
                                _this.props.onTermChanged(_query.term);
                            }

                            _this.setState({
                                pendingQuery: _query,
                                term: _query.term,
                                moreResultsEl: document.getElementsByClassName('select2-more-results')[0]
                            }, function () {
                                _this.props.onMoreItemsRequested(function (newItems) {
                                    if (_this.state.pendingQuery !== _query) {
                                        // something else happened in the meantime?
                                        return;
                                    }

                                    _this.setState({
                                        pendingItems: _this.state.pendingItems.concat(newItems)
                                    });
                                });
                            });
                        },
                        formatLoadMore: function formatLoadMore() {
                            return ' ';
                        }, // blank out the default text because we're replacing it with the spinner
                        ajax: undefined
                    };

                    var $filter = this.get$Input();
                    $filter.auiSelect2(_2['default'].extend(defaults, this.props.menu, overrides));
                    $filter.on('change', function () {
                        return _this.props.onChange();
                    });
                    $filter.on('select2-opening', function (e) {
                        if ($filter.select2('val')) {
                            // if there's a selection, force the clearing of it instead of opening.
                            e.preventDefault();
                            $filter.select2('val', '', true); // clear and trigger change
                        }
                    });
                    if (this.props.searchPlaceholder && !_navigatorUtil['default'].isIE()) {
                        // IE11 & below will fail - see STASHDEV-10518
                        $filter.one('select2-open', function () {
                            // make sure it's filtered by specific dropdown so this only affects the select2 that $filter belongs to
                            (0, _$['default'])('.filter-bar-dropdown-' + _this.props.id + ' .select2-search > input').attr('placeholder', _this.props.searchPlaceholder).after(_this.state.searchBoxSpinnerContainer);
                            if (_this.props.loading) {
                                _ReactDOM['default'].render(_React['default'].createElement(_Spinner['default'], null), _this.state.searchBoxSpinnerContainer);
                            }
                        });
                    }
                }

                // Note - we return false so that render never reruns.
            }, {
                key: 'shouldComponentUpdate',
                value: function shouldComponentUpdate(newProps, newState) {
                    var _this2 = this;

                    if (newProps.loading && newState.pendingQuery) {
                        // loading and there's a known query in the works
                        if (newState.pendingQuery.page <= 1 && newState.searchBoxSpinnerContainer.parentNode) {
                            _ReactDOM['default'].render(_React['default'].createElement(_Spinner['default'], null), newState.searchBoxSpinnerContainer);
                        }
                        if (newState.moreResultsEl) {
                            _ReactDOM['default'].render(_React['default'].createElement(_Spinner['default'], null), newState.moreResultsEl);
                        }
                    } else if (!newProps.loading && this.state.pendingQuery && newState.pendingQuery) {
                        (function () {
                            // loaded pre-existing query
                            if (newState.moreResultsEl) {
                                _ReactDOM['default'].unmountComponentAtNode(newState.moreResultsEl);
                            }
                            if (newState.searchBoxSpinnerContainer.children.length) {
                                _ReactDOM['default'].unmountComponentAtNode(newState.searchBoxSpinnerContainer);
                            }

                            var query = newState.pendingQuery; // grab the new one - grabbing the old one could get us into a loop.
                            var results = newState.pendingItems;
                            var more = !newProps.allFetched;

                            _this2.setState({
                                pendingItems: [],
                                pendingQuery: null
                            }, function () {
                                query.callback({
                                    context: query.context,
                                    results: results,
                                    more: more
                                });
                            });
                        })();
                    }

                    return false;
                }
            }, {
                key: 'get$Input',
                value: function get$Input() {
                    return (0, _$['default'])(_ReactDOM['default'].findDOMNode(this)).children('input');
                }
            }, {
                key: 'render',
                value: function render() {
                    return _React['default'].createElement(
                        'li',
                        null,
                        _React['default'].createElement(
                            'label',
                            { htmlFor: this.props.id, className: 'assistive' },
                            this.props.label
                        ),
                        _React['default'].createElement('input', { type: 'hidden', id: this.props.id, value: this.props.value || '' })
                    );
                }
            }, {
                key: 'value',
                value: function value() {
                    return this.props.value;
                }
            }, {
                key: 'domValue',
                value: function domValue() {
                    return this.get$Input().val();
                }
            }, {
                key: 'reset',
                value: function reset() {
                    var $filter = this.get$Input();
                    $filter.select2('val', false);
                    return _$['default'].Deferred().resolve();
                }
            }]);

            return AsyncSelect;
        })(_Filter2['default']);

        module.exports = AsyncSelect;
    }
);