define(
    'bitbucket/internal/bbui/pull-request-table/components/count-cell',
    ['exports', 'module', 'react'],
    function (exports, module, _react) {
        'use strict';

        function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

        var _React = _interopRequireDefault(_react);

        var UNCAPPED_MAX = 99;

        function cappedInt(n) {
            return n > UNCAPPED_MAX ? UNCAPPED_MAX + '+' : n + '';
        }

        var propTypes = {
            count: _react.PropTypes.number.isRequired,
            icon: _react.PropTypes.node.isRequired,
            tooltip: _react.PropTypes.string.isRequired
        };

        var CountCell = function CountCell(props) {
            return _React['default'].createElement(
                'td',
                { className: 'count-column-value' },
                props.count > 0 && _React['default'].createElement(
                    'span',
                    { title: props.tooltip },
                    props.icon,
                    _React['default'].createElement(
                        'span',
                        null,
                        ' '
                    ),
                    _React['default'].createElement(
                        'span',
                        { className: 'count' },
                        cappedInt(props.count)
                    )
                )
            );
        };

        CountCell.Header = function () {
            return _React['default'].createElement('th', { className: 'count-column' });
        };

        CountCell.propTypes = propTypes;

        module.exports = CountCell;
    }
);