define(
    'bitbucket/internal/bbui/mirroring-admin/request-view/request-view',
    ['exports', 'module', 'aui', 'aui/flag', 'jquery', 'lodash', 'bitbucket/internal/impl/request', '../../widget', '../nav-builder'],
    function (exports, module, _aui, _auiFlag, _jquery, _lodash, _bitbucketInternalImplRequest, _widget, _navBuilder) {
        'use strict';

        var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

        var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

        function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

        function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

        function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

        var _AJS = _interopRequireDefault(_aui);

        var _auiFlag2 = _interopRequireDefault(_auiFlag);

        var _$ = _interopRequireDefault(_jquery);

        var _2 = _interopRequireDefault(_lodash);

        var _ajax = _interopRequireDefault(_bitbucketInternalImplRequest);

        var _Widget2 = _interopRequireDefault(_widget);

        var _nav = _interopRequireDefault(_navBuilder);

        /**
         * Enum for mirror modes.
         * @readonly
         * @enum {string}
         */
        var MirrorMode = {
            ALL: 'all_projects',
            SELECTED: 'selected_projects'
        };

        /**
         * Enum for request resolutions.
         * @readonly
         * @enum {string}
         */
        var Resolutions = {
            ACCEPT: 'accept',
            REJECT: 'reject'
        };

        var RequestView = (function (_Widget) {
            _inherits(RequestView, _Widget);

            /**
             * The request view shows the approve/decline options for a mirror requesting approval.
             * @param {jQuery|HTMLElement} el - the container element that hosts this control
             * @param {object} options - Options for this RequestView
             * @param {MirrorRequest} options.item - The MirrorRequest for this RequestView
             */

            function RequestView(el, options) {
                _classCallCheck(this, RequestView);

                _get(Object.getPrototypeOf(RequestView.prototype), 'constructor', this).call(this, options);
                this.$el = (0, _$['default'])(el);
                this.$el.html(bitbucket.internal.component.mirroringAdmin.requestView.main(options));
                this.item = options.item;
                this.$el.find('#approve-mirror-button').on('click', this.approveMirrorButtonClicked);
                this.$el.find('#decline-mirror-button').on('click', this.declineMirrorButtonClicked);
            }

            _createClass(RequestView, [{
                key: 'destroy',
                value: function destroy() {
                    _get(Object.getPrototypeOf(RequestView.prototype), 'destroy', this).call(this);
                    this.$el.empty();
                    this.$el = null;
                    this.item = null;
                }
            }, {
                key: 'approveMirrorButtonClicked',
                value: function approveMirrorButtonClicked(e) {
                    //Need to prevent the form from submitting and reloading the page.
                    e.preventDefault();
                    this.resolveRequest(Resolutions.ACCEPT, this.$el.find('#all-projects-radio').is(':checked') ? MirrorMode.ALL : MirrorMode.SELECTED);
                }

                /**
                 * Shows a modal confirmation dialog to confirm declining a mirror request.
                 */
            }, {
                key: 'confirmDeclineMirror',
                value: function confirmDeclineMirror() {
                    var _this = this;

                    var $dialogEl = (0, _$['default'])(bitbucket.internal.component.mirroringAdmin.requestView.declineDialog({
                        mirrorName: this.item.mirrorName
                    }));
                    this.$el.append($dialogEl);

                    var dialog = _AJS['default'].dialog2('#decline-mirror-request-dialog');

                    dialog.on('hide', function () {
                        $dialogEl.remove();
                    });

                    $dialogEl.find('#dialog-decline-button').click(function () {
                        _this.resolveRequest(Resolutions.REJECT);
                        dialog.hide();
                    });

                    $dialogEl.find('#dialog-cancel-button').click(function () {
                        return dialog.hide();
                    });

                    dialog.show();
                }
            }, {
                key: 'declineMirrorButtonClicked',
                value: function declineMirrorButtonClicked(e) {
                    //Need to prevent the form from submitting and reloading the page.
                    e.preventDefault();
                    this.confirmDeclineMirror();
                }

                /**
                 * Resolve a mirroring request.
                 * @param {Resolutions} resolution - The Resolutions to resolve this request with
                 * @param {MirrorMode?} mirroringMode - The MirrorMode to resolve this request with
                 */
            }, {
                key: 'resolveRequest',
                value: function resolveRequest(resolution, mirroringMode) {
                    var _this2 = this;

                    var id = this.item.id;
                    this._showSpinner();
                    _ajax['default'].rest({
                        type: 'POST',
                        url: _nav['default'].rest().mirroring().path('requests', id, resolution).params(mirroringMode ? { mirroringMode: mirroringMode } : null).build(),
                        statusCode: {
                            '*': false
                        }
                    }).done(function (response) {
                        _this2._mirrorRequestActionSuccess(resolution);

                        /**
                         * A request resolved event object.
                         * @typedef {Object} RequestResolvedObject
                         * @property {string}   id              - The ID of the request that was resolved
                         * @property {string}   type            - The type of item that was resolved.
                         * @property {string}   resolution      - The resolution. Can be accepted or rejected.
                         * @property {JSON}     responseJSON    - The JSON returned by the REST request.
                         */
                        _this2.trigger('request-resolved', {
                            id: id,
                            type: 'request',
                            resolution: resolution,
                            responseJSON: response
                        });
                    }).fail(function (response) {
                        var errors = _2['default'].get(response, 'responseJSON.errors');
                        if (errors) {
                            // one of our REST errors
                            return _this2._mirrorRequestActionFailed(resolution, errors);
                        }
                        throw response; // some other error; Bubble it up.
                    }).always(this._stopSpinner);
                }

                /**
                 * Shows a flag indicating approving the mirror has failed.
                 *
                 * @param {Resolutions} resolution - The resolution for the failed request
                 * @param {Array} errors - The errors that occured
                 */
            }, {
                key: '_mirrorRequestActionFailed',
                value: function _mirrorRequestActionFailed(resolution, errors) {
                    var mirrorName = this.item.mirrorName;
                    (0, _auiFlag2['default'])({
                        type: 'error',
                        title: resolution === Resolutions.ACCEPT ? _AJS['default'].I18n.getText('bitbucket.component.mirroring.admin.request.view.flags.request.approve.failure', mirrorName) : _AJS['default'].I18n.getText('bitbucket.component.mirroring.admin.request.view.flags.request.reject.failure', mirrorName),
                        body: errors.map(function (error) {
                            return _AJS['default'].escapeHtml(error.message);
                        }).join(',')
                    });
                }

                /**
                 * Shows a flag indicating approving the mirror has succeeded.
                 *
                 * @param {Resolutions} resolution - The Resolutions that the mirroring request succeeded with
                 */
            }, {
                key: '_mirrorRequestActionSuccess',
                value: function _mirrorRequestActionSuccess(resolution) {
                    var mirrorName = this.item.mirrorName;
                    (0, _auiFlag2['default'])({
                        type: 'success',
                        title: resolution === Resolutions.ACCEPT ? _AJS['default'].I18n.getText('bitbucket.component.mirroring.admin.request.view.flags.request.approve.success', mirrorName) : _AJS['default'].I18n.getText('bitbucket.component.mirroring.admin.request.view.flags.request.reject.success', mirrorName),
                        persistent: false,
                        close: 'auto',
                        body: ''
                    });
                }
            }, {
                key: '_showSpinner',
                value: function _showSpinner() {
                    _AJS['default'].$('#mirror-action-button-spinner').spin();
                }
            }, {
                key: '_stopSpinner',
                value: function _stopSpinner() {
                    _AJS['default'].$('#mirror-action-button-spinner').spinStop();
                }
            }]);

            return RequestView;
        })(_Widget2['default']);

        module.exports = RequestView;
    }
);