define(
    'bitbucket/internal/bbui/inbox',
    ['exports', 'module', 'react', 'jquery', 'lodash', './aui-react/avatar', './aui-react/spinner', './models', './paged-table', './pull-request-table/components/comments', './pull-request-table/components/pull-request-row', './pull-request-table/components/reviewers', './pull-request-table/components/tasks', './pull-request-table/components/web-section', './utils/pull-request-unique-id', './inbox/components/summary'],
    function (exports, module, _react, _jquery, _lodash, _auiReactAvatar, _auiReactSpinner, _models, _pagedTable, _pullRequestTableComponentsComments, _pullRequestTableComponentsPullRequestRow, _pullRequestTableComponentsReviewers, _pullRequestTableComponentsTasks, _pullRequestTableComponentsWebSection, _utilsPullRequestUniqueId, _componentsSummary) {
        'use strict';

        var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

        var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

        var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

        function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

        function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

        function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

        var _React = _interopRequireDefault(_react);

        var _$ = _interopRequireDefault(_jquery);

        var _2 = _interopRequireDefault(_lodash);

        var _Avatar = _interopRequireDefault(_auiReactAvatar);

        var _Spinner = _interopRequireDefault(_auiReactSpinner);

        var _models2 = _interopRequireDefault(_models);

        var _PagedTable = _interopRequireDefault(_pagedTable);

        var _Comments = _interopRequireDefault(_pullRequestTableComponentsComments);

        var _PullRequestRow = _interopRequireDefault(_pullRequestTableComponentsPullRequestRow);

        var _Reviewers = _interopRequireDefault(_pullRequestTableComponentsReviewers);

        var _Tasks = _interopRequireDefault(_pullRequestTableComponentsTasks);

        var _prUniqueId = _interopRequireDefault(_utilsPullRequestUniqueId);

        var _Summary = _interopRequireDefault(_componentsSummary);

        var Inbox = (function (_Component) {
            _inherits(Inbox, _Component);

            function Inbox() {
                _classCallCheck(this, Inbox);

                _get(Object.getPrototypeOf(Inbox.prototype), 'constructor', this).apply(this, arguments);
            }

            _createClass(Inbox, [{
                key: 'componentDidMount',
                value: function componentDidMount() {
                    (0, _$['default'])(document).on('click', '.inbox-table-wrapper .tabs-menu a', this.changeTabs);

                    this.props.created.onMoreItemsRequested();
                    this.props.reviewing.onMoreItemsRequested();
                }
            }, {
                key: 'componentWillUnmount',
                value: function componentWillUnmount() {
                    (0, _$['default'])(document).off('click', '.inbox-table-wrapper .tabs-menu a', this.changeTabs);
                }
            }, {
                key: 'changeTabs',
                value: function changeTabs(event) {
                    AJS.tabs.change((0, _$['default'])(event.currentTarget), event);
                    event.preventDefault();
                }
            }, {
                key: 'isPrReviewed',
                value: function isPrReviewed(reviewers, currentUser) {
                    return _2['default'].some(reviewers, function (reviewer) {
                        return reviewer.user.name === currentUser.name && reviewer.state === _models2['default'].ApprovalState.NEEDS_WORK;
                    });
                }
            }, {
                key: 'render',
                value: function render() {
                    var _this = this;

                    var props = this.props;
                    var emptyInbox = _React['default'].createElement(
                        'div',
                        { className: 'empty-inbox-message' },
                        _React['default'].createElement(
                            'span',
                            { className: 'aui-icon aui-icon-large aui-iconfont-workbox-empty' },
                            AJS.I18n.getText('bitbucket.component.inbox.empty.description')
                        ),
                        _React['default'].createElement(
                            'h3',
                            null,
                            AJS.I18n.getText('bitbucket.component.inbox.empty.title')
                        )
                    );

                    var reviewingContent = props.reviewing.pullRequests.length || props.reviewing.loading ? _React['default'].createElement(_PagedTable['default'], _extends({}, props.reviewing, {
                        className: 'pull-requests-table',
                        allFetchedMessage: AJS.I18n.getText('bitbucket.pull.request.all.fetched'),
                        items: props.reviewing.pullRequests,
                        onMoreItemsRequested: props.reviewing.onMoreItemsRequested,
                        scrollElement: '.inbox-table-wrapper',
                        row: function (_ref) {
                            var item = _ref.item;
                            var focused = _ref.focused;

                            var pullRequest = item;
                            return _React['default'].createElement(
                                _PullRequestRow['default'],
                                {
                                    key: (0, _prUniqueId['default'])(pullRequest),
                                    focused: focused,
                                    prNeedsWork: _this.isPrReviewed(pullRequest.reviewers, props.currentUser)
                                },
                                _React['default'].createElement(
                                    'td',
                                    { className: 'author-avatar' },
                                    _React['default'].createElement(_Avatar['default'], { person: pullRequest.author, size: 'medium' })
                                ),
                                _React['default'].createElement(_Summary['default'], { pullRequest: pullRequest }),
                                _pullRequestTableComponentsWebSection.beforeSections.map(function (section) {
                                    return _React['default'].createElement(_pullRequestTableComponentsWebSection.WebSectionTD, {
                                        key: section.key + '::before',
                                        where: 'before',
                                        webSection: section,
                                        pullRequest: pullRequest
                                    });
                                }),
                                _React['default'].createElement(_Reviewers['default'], {
                                    currentUser: props.currentUser,
                                    currentUserAvatarSize: 'medium',
                                    dialogReviewersAsTooltip: true,
                                    pullRequest: pullRequest
                                }),
                                _React['default'].createElement(_Comments['default'], { pullRequest: pullRequest }),
                                _React['default'].createElement(_Tasks['default'], { pullRequest: pullRequest })
                            );
                        }
                    })) : emptyInbox;

                    var createdContent = props.created.pullRequests.length || props.created.loading ? _React['default'].createElement(_PagedTable['default'], _extends({}, props.created, {
                        className: 'pull-requests-table',
                        allFetchedMessage: AJS.I18n.getText('bitbucket.pull.request.all.fetched'),
                        items: props.created.pullRequests,
                        onMoreItemsRequested: props.created.onMoreItemsRequested,
                        scrollElement: '.inbox-table-wrapper',
                        row: function (_ref2) {
                            var item = _ref2.item;
                            var focused = _ref2.focused;

                            var pullRequest = item;
                            return _React['default'].createElement(
                                _PullRequestRow['default'],
                                { key: (0, _prUniqueId['default'])(pullRequest), focused: focused },
                                _React['default'].createElement(_Summary['default'], { pullRequest: pullRequest }),
                                _pullRequestTableComponentsWebSection.beforeSections.map(function (section) {
                                    return _React['default'].createElement(_pullRequestTableComponentsWebSection.WebSectionTD, {
                                        key: section.key + '::before',
                                        where: 'before',
                                        webSection: section,
                                        pullRequest: pullRequest
                                    });
                                }),
                                _React['default'].createElement(_Reviewers['default'], {
                                    pullRequest: pullRequest,
                                    dialogReviewersAsTooltip: true
                                }),
                                _React['default'].createElement(_Comments['default'], { pullRequest: pullRequest }),
                                _React['default'].createElement(_Tasks['default'], { pullRequest: pullRequest })
                            );
                        }
                    })) : emptyInbox;

                    var dialogContent = !props.reviewing.pullRequests.length && !props.created.pullRequests.length && (props.reviewing.loading || props.created.loading) ? _React['default'].createElement(
                        'div',
                        { className: 'inbox-spinner-padding' },
                        _React['default'].createElement(_Spinner['default'], null)
                    ) : _React['default'].createElement(
                        'div',
                        { id: 'inbox-wapper' },
                        _React['default'].createElement(
                            'h2',
                            null,
                            AJS.I18n.getText('bitbucket.component.inbox.title')
                        ),
                        _React['default'].createElement(
                            'div',
                            { className: 'inbox-table-wrapper aui-tabs horizontal-tabs' },
                            _React['default'].createElement(
                                'ul',
                                { className: 'tabs-menu' },
                                _React['default'].createElement(
                                    'li',
                                    { className: 'menu-item active-tab' },
                                    _React['default'].createElement(
                                        'a',
                                        { href: '#inbox-pull-request-reviewer' },
                                        AJS.I18n.getText('bitbucket.component.inbox.reviewing')
                                    )
                                ),
                                _React['default'].createElement(
                                    'li',
                                    { className: 'menu-item' },
                                    _React['default'].createElement(
                                        'a',
                                        { href: '#inbox-pull-request-created' },
                                        AJS.I18n.getText('bitbucket.component.inbox.created')
                                    )
                                )
                            ),
                            _React['default'].createElement(
                                'div',
                                { id: 'inbox-pull-request-reviewer', className: 'tabs-pane active-pane' },
                                reviewingContent
                            ),
                            _React['default'].createElement(
                                'div',
                                { id: 'inbox-pull-request-created', className: 'tabs-pane' },
                                createdContent
                            )
                        )
                    );

                    return dialogContent;
                }
            }], [{
                key: 'propTypes',
                get: function get() {
                    return {
                        created: _react.PropTypes.shape({
                            allFetched: _react.PropTypes.bool.isRequired,
                            loading: _react.PropTypes.bool.isRequired,
                            onMoreItemsRequested: _react.PropTypes.func.isRequired,
                            pullRequests: _react.PropTypes.array.isRequired
                        }).isRequired,
                        currentUser: _react.PropTypes.object.isRequired,
                        reviewing: _react.PropTypes.shape({
                            allFetched: _react.PropTypes.bool.isRequired,
                            loading: _react.PropTypes.bool.isRequired,
                            onMoreItemsRequested: _react.PropTypes.func.isRequired,
                            pullRequests: _react.PropTypes.array.isRequired
                        }).isRequired
                    };
                }
            }]);

            return Inbox;
        })(_react.Component);

        module.exports = Inbox;
    }
);