define(
    'bitbucket/internal/bbui/filter-bar',
    ['exports', 'module', 'jquery', 'react', './filter-bar/components/async-select', './filter-bar/components/filter', './filter-bar/components/select', './filter-bar/components/toggle'],
    function (exports, module, _jquery, _react, _componentsAsyncSelect, _componentsFilter, _componentsSelect, _componentsToggle) {
        'use strict';

        var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

        var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

        function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

        function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) arr2[i] = arr[i]; return arr2; } else { return Array.from(arr); } }

        function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

        function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

        var _$ = _interopRequireDefault(_jquery);

        var _React = _interopRequireDefault(_react);

        var _AsyncSelect = _interopRequireDefault(_componentsAsyncSelect);

        var _Filter = _interopRequireDefault(_componentsFilter);

        var _Select = _interopRequireDefault(_componentsSelect);

        var _Toggle = _interopRequireDefault(_componentsToggle);

        /**
         * Calls React.cloneElement, but for any props that already contains callbacks, combines the callbacks and ensures both the old version
         * and new version are called.
         *
         * If you've got a better name, and I'm sure you do, please rename this.
         *
         * @param {ReactElement} el - el to clone
         * @param {Object} newProps - properties to override
         * @returns {ReactElement}
         */
        function cloneSequencedOverwrite(el, newProps) {
            var combinedProps = {};
            var _iteratorNormalCompletion = true;
            var _didIteratorError = false;
            var _iteratorError = undefined;

            try {
                var _loop = function () {
                    var prop = _step.value;

                    var val = newProps[prop];
                    if (val === undefined) {
                        return 'continue'; // ignore it
                    }
                    if (typeof val !== 'function' || typeof el[prop] !== 'function') {
                        combinedProps[prop] = val;
                    } else {
                        (function () {
                            var oldFn = el[prop];
                            combinedProps[prop] = function () {
                                oldFn.apply(this, arguments);
                                return val.apply(this, arguments);
                            };
                        })();
                    }
                };

                for (var _iterator = Object.keys(newProps)[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
                    var _ret = _loop();

                    if (_ret === 'continue') continue;
                }
            } catch (err) {
                _didIteratorError = true;
                _iteratorError = err;
            } finally {
                try {
                    if (!_iteratorNormalCompletion && _iterator['return']) {
                        _iterator['return']();
                    }
                } finally {
                    if (_didIteratorError) {
                        throw _iteratorError;
                    }
                }
            }

            return _React['default'].cloneElement(el, combinedProps);
        }

        var FilterBar = (function (_Component) {
            _inherits(FilterBar, _Component);

            _createClass(FilterBar, null, [{
                key: 'propTypes',
                get: function get() {
                    return {
                        children: _react.PropTypes.any,
                        onChange: _react.PropTypes.func,
                        id: _react.PropTypes.string
                    };
                }
            }]);

            function FilterBar() {
                _classCallCheck(this, FilterBar);

                for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
                    args[_key] = arguments[_key];
                }

                _get(Object.getPrototypeOf(FilterBar.prototype), 'constructor', this).apply(this, args);

                this.filterRefs = [];
            }

            _createClass(FilterBar, [{
                key: 'getState',
                value: function getState() {
                    var state = {};
                    this.filterRefs.forEach(function (filter) {
                        if (!filter) {
                            return;
                        }
                        state[filter.props.id] = filter.domValue();
                    });
                    return state;
                }
            }, {
                key: 'reset',
                value: function reset() {
                    var _this = this;

                    var oldState = this.getState();
                    var resetPromises = this.filterRefs.map(function (filter) {
                        if (!filter) {
                            return _$['default'].Deferred().resolve();
                        }
                        return filter.reset();
                    });
                    _$['default'].when.apply(_$['default'], _toConsumableArray(resetPromises)).then(function () {
                        var newState = _this.getState();
                        if (Object.keys(newState).some(function (prop) {
                            return newState[prop] !== oldState[prop];
                        })) {
                            _this.props.onChange(newState);
                        }
                    });
                }
            }, {
                key: 'render',
                value: function render() {
                    var _this2 = this;

                    var onChange = undefined;
                    if (this.props.onChange) {
                        onChange = function () {
                            _this2.props.onChange(_this2.getState());
                        };
                    }

                    return _React['default'].createElement(
                        'div',
                        { className: 'filter-bar', id: this.props.id },
                        _React['default'].createElement(
                            'h6',
                            { className: 'filter-label' },
                            AJS.I18n.getText('bitbucket.component.filter.bar.label')
                        ),
                        _React['default'].createElement(
                            'ul',
                            null,
                            _React['default'].Children.map(this.props.children, function (c, i) {
                                if (!c || !(c.type.prototype instanceof _Filter['default'])) {
                                    return c;
                                }
                                return cloneSequencedOverwrite(c, {
                                    onChange: onChange || undefined,
                                    ref: function ref(r) {
                                        return _this2.filterRefs[i] = r;
                                    }
                                });
                            })
                        )
                    );
                }
            }]);

            return FilterBar;
        })(_react.Component);

        module.exports = FilterBar;

        FilterBar.AsyncSelect = _AsyncSelect['default'];
        FilterBar.Select = _Select['default'];
        FilterBar.Toggle = _Toggle['default'];
    }
);