define(
    'bitbucket/internal/bbui/avatar-list',
    ['exports', 'module', 'jquery', 'lodash'],
    function (exports, module, _jquery, _lodash) {
        'use strict';

        function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

        var _$ = _interopRequireDefault(_jquery);

        var _2 = _interopRequireDefault(_lodash);

        var approvalOrder = {
            APPROVED: 1,
            NEEDS_WORK: 2,
            UNAPPROVED: 3
        };

        module.exports = {
            updateApproval: function updateApproval(listEl, participant) {
                var $avatars = (0, _$['default'])(listEl).find(".user-avatar[data-username='" + participant.getUser().getName() + "']");
                $avatars.toggleClass('badge-hidden', !participant.getApproved());
            },
            sortParticipants: function sortParticipants(participants) {
                function compare(a, b) {
                    return approvalOrder[a.state] - approvalOrder[b.state] || a.user.display_name.localeCompare(b.user.display_name);
                }
                return participants.sort(compare);
            },
            init: _2['default'].once(function () {
                (0, _$['default'])('.avatar-tooltip > .aui-avatar-inner > img').tooltip({
                    hoverable: false,
                    offset: 5,
                    gravity: function gravity() {
                        // Always position on screen
                        return _$['default'].fn.tipsy.autoNS.call(this) + _$['default'].fn.tipsy.autoWE.call(this);
                    },
                    delayIn: 0,
                    live: true
                });
            })
        };
    }
);