define(
    'bitbucket/internal/bbui/reviewer-avatar-list',
    ['exports', 'module', 'react', 'classnames', 'lodash', './aui-react/inline-dialog', './models', './reviewer-avatar', './self-reviewer'],
    function (exports, module, _react, _classnames, _lodash, _auiReactInlineDialog, _models, _reviewerAvatar, _selfReviewer) {
        'use strict';

        var _slicedToArray = (function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i['return']) _i['return'](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError('Invalid attempt to destructure non-iterable instance'); } }; })();

        var _statusMap;

        function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

        function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

        var _React = _interopRequireDefault(_react);

        var _classNames = _interopRequireDefault(_classnames);

        var _2 = _interopRequireDefault(_lodash);

        var _InlineDialog = _interopRequireDefault(_auiReactInlineDialog);

        var _models2 = _interopRequireDefault(_models);

        var _ReviewerAvatar = _interopRequireDefault(_reviewerAvatar);

        var _SelfReviewer = _interopRequireDefault(_selfReviewer);

        var propTypes = {
            avatarSize: _react.PropTypes.string,
            currentUserAsReviewer: _react.PropTypes.object,
            isWatching: _react.PropTypes.bool,
            maxOpen: _react.PropTypes.number,
            menuId: _react.PropTypes.string.isRequired,
            onSelfClick: _react.PropTypes.func,
            reviewers: _react.PropTypes.array.isRequired,
            reverse: _react.PropTypes.bool,
            triggerClass: _react.PropTypes.string,
            permissionToReview: _react.PropTypes.bool.isRequired,
            pullRequestIsOpen: _react.PropTypes.bool.isRequired,
            currentUserAvatarSize: _react.PropTypes.string,
            dialogReviewersAsTooltip: _react.PropTypes.bool
        };

        var approvalOrder = {
            APPROVED: 1,
            NEEDS_WORK: 2,
            UNAPPROVED: 3
        };

        var statusMap = (_statusMap = {}, _defineProperty(_statusMap, _models2['default'].ApprovalState.APPROVED, AJS.I18n.getText('bitbucket.component.avatar.badge.approved')), _defineProperty(_statusMap, _models2['default'].ApprovalState.NEEDS_WORK, AJS.I18n.getText('bitbucket.component.avatar.badge.needs.work')), _statusMap);

        function sortReviewers(reviewers) {
            return reviewers.slice().sort(function (a, b) {
                return approvalOrder[a.state] - approvalOrder[b.state] || a.user.display_name.localeCompare(b.user.display_name);
            });
        }

        /**
         * Displays a list of avatars
         *
         * @param {Object} props - Component properties
         * @param {Array} props.reviewers - The reviewers
         * @param {string} props.menuId - ID for the overflow dialog
         * @param {string?} props.triggerClass - Additional classes for the overflow dialog trigger
         * @param {number?} props.maxOpen - Maximum number of reviewers to show before overflow
         * @param {string?} props.avatarSize - Avatar size to show reviewers at
         * @param {boolean?} props.reverse - Order to show reviewers
         * @returns {ReactElement} - rendered component
         */
        var ReviewerAvatarList = function ReviewerAvatarList(props) {
            var sortedReviewers = sortReviewers(props.reviewers);
            var currentUserIndex = _2['default'].findIndex(sortedReviewers, function (user) {
                if (!props.currentUserAsReviewer) {
                    return false;
                }
                return user.user.name === (props.currentUserAsReviewer.name || props.currentUserAsReviewer.user.name);
            });
            var showingSelfReviewer = props.permissionToReview && props.pullRequestIsOpen;
            var maxOpen = showingSelfReviewer ? props.maxOpen - 1 : props.maxOpen;
            if (currentUserIndex > -1) {
                // remove current user from ReviewerAvatarList,

                var _sortedReviewers$splice = sortedReviewers.splice(currentUserIndex, 1);

                var _sortedReviewers$splice2 = _slicedToArray(_sortedReviewers$splice, 1);

                var currentUser = _sortedReviewers$splice2[0];

                // put the currentUser in front when
                // SelfReviewer component is hidden
                // or if we want to change the current user's avatar size
                if (!showingSelfReviewer || props.currentUserAvatarSize) {
                    sortedReviewers.unshift(currentUser);
                }
            }

            var visibleReviewers = undefined;
            var dialogReviewers = undefined;
            if (sortedReviewers.length > maxOpen) {
                visibleReviewers = sortedReviewers.slice(0, maxOpen - 1);
                dialogReviewers = sortedReviewers.slice(maxOpen - 1);
            } else {
                visibleReviewers = sortedReviewers;
                dialogReviewers = [];
            }

            var visibleAvatars = visibleReviewers.map(function (reviewer) {
                return _React['default'].createElement(_ReviewerAvatar['default'], {
                    reviewer: reviewer,
                    key: reviewer.user.name,
                    avatarSize: props.currentUserAsReviewer && props.currentUserAvatarSize && reviewer.user.name === props.currentUserAsReviewer.name ? props.currentUserAvatarSize : 'small'
                });
            });
            var children = visibleAvatars.slice();

            if (showingSelfReviewer) {
                children.unshift(_React['default'].createElement(_SelfReviewer['default'], {
                    key: 'self_reviewer',
                    removeSelfModalId: 'remove-self-modal',
                    currentUserAsReviewer: props.currentUserAsReviewer,
                    isWatching: props.isWatching,
                    onSelfClick: props.onSelfClick
                }));
            }

            if (dialogReviewers.length) {
                if (props.dialogReviewersAsTooltip) {
                    var tooltipString = '';
                    dialogReviewers.map(function (reviewer, i, arr) {
                        tooltipString += reviewer.user.name;
                        if (reviewer.state !== _models2['default'].ApprovalState.UNAPPROVED) {
                            tooltipString += ' (' + statusMap[reviewer.state] + ')';
                        }
                        if (i + 1 < arr.length) {
                            tooltipString += '<br>';
                        }
                    });
                    children.push(_React['default'].createElement(
                        'button',
                        {
                            className: 'overflow-reviewers-trigger overflow-reviewers-tooltip aui-button aui-button-subtle',
                            key: 'overflow-reviewers-tooltip',
                            title: tooltipString,
                            ref: function (el) {
                                return AJS.$(el).tooltip({
                                    html: true
                                });
                            }
                        },
                        '+',
                        dialogReviewers.length
                    ));
                } else {
                    children.push(_React['default'].createElement(
                        _auiReactInlineDialog.InlineDialogTrigger,
                        {
                            key: 'trigger',
                            dialogId: props.menuId,
                            className: (0, _classNames['default'])('aui-button-subtle overflow-reviewers-trigger', props.triggerClass)
                        },
                        '+',
                        dialogReviewers.length
                    ));
                    children.push(_React['default'].createElement(
                        _InlineDialog['default'],
                        {
                            key: 'dialog',
                            id: props.menuId,
                            className: 'overflow-reviewers',
                            alignment: props.reverse ? 'left top' : 'bottom right'
                        },
                        _React['default'].createElement(
                            'div',
                            { className: 'avatar-dropdown' },
                            _React['default'].createElement(
                                'ul',
                                { className: 'aui-list-truncate' },
                                dialogReviewers.map(function (reviewer) {
                                    return _React['default'].createElement(
                                        'li',
                                        { key: reviewer.user.name },
                                        _React['default'].createElement(_ReviewerAvatar['default'], { reviewer: reviewer, tooltip: false, nameOnly: true, withName: true })
                                    );
                                })
                            )
                        )
                    ));
                }
            }

            return _React['default'].createElement(
                'div',
                { className: (0, _classNames['default'])('reviewer-avatar-list', { reversed: props.reverse }) },
                props.reverse ? children.reverse() : children
            );
        };

        ReviewerAvatarList.propTypes = propTypes;
        module.exports = ReviewerAvatarList;
    }
);
// instead shown in SelfReviewer component