define(
    'bitbucket/internal/bbui/data-provider/data-provider',
    ['exports', 'module', 'jquery', './../javascript-errors', './../json-validation', './../widget'],
    function (exports, module, _jquery, _javascriptErrors, _jsonValidation, _widget) {
        'use strict';

        var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

        var _get = function get(_x4, _x5, _x6) { var _again = true; _function: while (_again) { var object = _x4, property = _x5, receiver = _x6; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x4 = parent; _x5 = property; _x6 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

        function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

        function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

        function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

        var _$ = _interopRequireDefault(_jquery);

        var _errors = _interopRequireDefault(_javascriptErrors);

        var _validator = _interopRequireDefault(_jsonValidation);

        var _Widget2 = _interopRequireDefault(_widget);

        var NotImplementedError = _errors['default'].NotImplementedError;

        /**
         * The DataProvider is a relatively abstract class that provides some basic data fetching and management.
         * Each product should implement its own version of this to then provide to consumers (components).
         *
         * Data provided to a DataProvider is expect to at the least have an array of values along with some metadata.
         * The metadata will differ per product and this will be dealt with in the product specific implementations.
         *
         */

        var DataProvider = (function (_Widget) {
            _inherits(DataProvider, _Widget);

            /**
             * @param {Object} options - The options for the Data Provider
             * @param {Object?} options.jsonDescriptor - If provided, transformed data will be validated against this shape.
             *                                           See the rules in declarative-validation.js and reference the unit tests.
                                                         If not provided, _validate must be implemented in a subclass.
             * @param {Object?} initialData - The initial data for this provider
             */

            function DataProvider() {
                var options = arguments.length <= 0 || arguments[0] === undefined ? {} : arguments[0];
                var initialData = arguments.length <= 1 || arguments[1] === undefined ? null : arguments[1];

                _classCallCheck(this, DataProvider);

                _get(Object.getPrototypeOf(DataProvider.prototype), 'constructor', this).call(this, options);
                this.initialData = initialData;

                if (this.options.jsonDescriptor) {
                    this._validate = (0, _validator['default'])(this.options.jsonDescriptor);
                }
            }

            /**
             * If the data provider is currently fetching data with an XHR request, this will return true.
             *
             * Checks for the presence of the DataProvider#_requestPromise
             *
             * @returns {boolean}
             */

            _createClass(DataProvider, [{
                key: 'reset',

                /**
                 * Reset the data for this provider.
                 */
                value: function reset() {
                    this.abort();
                    this.currentData = null;
                    delete this.initialData;
                    this.trigger('reset');
                }

                /**
                 * Cancel any in-flight requests and nullify the request promise
                 */
            }, {
                key: 'abort',
                value: function abort() {
                    if (this._requestPromise) {
                        this._requestPromise.abort();
                        this._requestPromise = null;
                        this.trigger('abort');
                    }
                }

                /**
                 * Perform the AJAX request for this DataProvider.
                 * If called and there is currentData use the locally cached version.
                 *
                 * This means that {DataProvider#currentData} needs to be invalidated if
                 * you want to force the fetching of data from the server on subsequent requests.
                 *
                 * @param {string?} url - the url to fetch data from. defaults to the base url
                 *
                 * @returns {Promise}
                 */
            }, {
                key: 'fetch',
                value: function fetch() {
                    var _this = this;

                    var url = arguments.length <= 0 || arguments[0] === undefined ? this.url : arguments[0];

                    // If a fetch is attempted before the previous fetch has returned,
                    // then abort the previous fetch and continue with the new request.
                    this.abort();

                    // If there is initial data, upgrade the currentData to initialData
                    if (this.initialData) {
                        this.currentData = this.transform(this.initialData);
                        // initialData is single use, delete it after it has been consumed
                        delete this.initialData;
                    }

                    // If there is a set of currentData then return it.
                    if (this.currentData) {
                        return _$['default'].Deferred().resolve(this.currentData);
                    }

                    this.trigger('data-requested');

                    this._requestPromise = this._fetch(url);

                    // The promise from _fetch must be abortable.
                    if (!this._requestPromise.abort) {
                        throw new Error('no abort method on DataProvider#_requestPromise.');
                    }

                    return this._requestPromise.then(this.transform, function () {
                        return _$['default'].Deferred().reject(_this.errorTransform.apply(_this, arguments));
                    }).done(function (transformedData) {
                        _this.trigger('data-loaded', transformedData);
                        _this.currentData = transformedData;
                    }).fail(function (error) {
                        _this.trigger('data-request-failed', error);
                    }).always(function () {
                        _this._requestPromise = null;
                    });
                }

                /*eslint-disable valid-jsdoc*/ // Disable JSDoc validation for interface
                /**
                 * Perform a request to fetch data.
                 *
                 * @returns {Promise} - a jqxhr promise. This promise should be abortable.
                 * @protected
                 */
            }, {
                key: '_fetch',
                value: function _fetch() {
                    throw new NotImplementedError();
                }

                /**
                 * Transform the results from a REST request to the format required
                 * by a consumer of a component data provider.
                 *
                 * @returns {Object} The transformed results
                 */
            }, {
                key: 'transform',
                value: function transform() {
                    var out = this._transform.apply(this, arguments);
                    this._validate(out);
                    return out;
                }

                /**
                 * @returns {Object}
                 * @protected
                 */
            }, {
                key: '_transform',
                value: function _transform() {
                    throw new NotImplementedError();
                }

                /**
                 * Throw an error if the transformed data doesn't have the required shape.
                 * If a jsonDescriptor is provided, it will be used for validation.
                 * @protected
                 *
                 * @param {Object} data - The data to validate
                 */
            }, {
                key: '_validate',
                value: function _validate(data) {
                    // eslint-disable-line no-unused-vars
                    throw new NotImplementedError();
                }

                /**
                 * Transform the errors from a REST request to the format required
                 * by a consumer of a component data provider.
                 *
                 * @returns {Object|string}
                 */
            }, {
                key: 'errorTransform',
                value: function errorTransform() {
                    return this._errorTransform.apply(this, arguments);
                }

                /**
                 * @returns {Object|string}
                 * @protected
                 */
            }, {
                key: '_errorTransform',
                value: function _errorTransform() {
                    throw new NotImplementedError();
                }

                /*eslint-enable valid-jsdoc*/
            }, {
                key: 'isFetching',
                get: function get() {
                    return !!this._requestPromise;
                }
            }]);

            return DataProvider;
        })(_Widget2['default']);

        module.exports = DataProvider;
    }
);