define(
    'bitbucket/internal/bbui/pull-request-list-table',
    ['exports', 'module', 'react', './paged-table', './pull-request-table/components/comments', './pull-request-table/components/pull-request-row', './pull-request-table/components/reviewers', './pull-request-table/components/tasks', './pull-request-table/components/web-section', './pull-request-list-table/components/summary'],
    function (exports, module, _react, _pagedTable, _pullRequestTableComponentsComments, _pullRequestTableComponentsPullRequestRow, _pullRequestTableComponentsReviewers, _pullRequestTableComponentsTasks, _pullRequestTableComponentsWebSection, _componentsSummary) {
        'use strict';

        var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

        function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

        var _React = _interopRequireDefault(_react);

        var _PagedTable = _interopRequireDefault(_pagedTable);

        var _Comments = _interopRequireDefault(_pullRequestTableComponentsComments);

        var _PullRequestRow = _interopRequireDefault(_pullRequestTableComponentsPullRequestRow);

        var _Reviewers = _interopRequireDefault(_pullRequestTableComponentsReviewers);

        var _Tasks = _interopRequireDefault(_pullRequestTableComponentsTasks);

        var _Summary = _interopRequireDefault(_componentsSummary);

        var propTypes = {
            focusedIndex: _react.PropTypes.number,
            pullRequests: _react.PropTypes.array.isRequired, // ideally we'd validate the PR shapes
            allFetchedMessage: _react.PropTypes.string
        };

        var PullRequestListTable = function PullRequestListTable(props) {
            var pullRequests = props.pullRequests;
            return _React['default'].createElement(_PagedTable['default'], _extends({}, props, {
                className: 'pull-requests-table',
                allFetchedMessage: AJS.I18n.getText('bitbucket.pull.request.all.fetched'),
                items: pullRequests,
                header: function () {
                    return _React['default'].createElement(
                        _PullRequestRow['default'],
                        null,
                        _React['default'].createElement(_Summary['default'].Header, null),
                        _pullRequestTableComponentsWebSection.beforeSections.map(function (section) {
                            return _React['default'].createElement(_pullRequestTableComponentsWebSection.WebSectionTH, { key: section.key + '::before', webSection: section });
                        }),
                        _React['default'].createElement(_Comments['default'].Header, null),
                        _React['default'].createElement(_Tasks['default'].Header, null),
                        _React['default'].createElement(_Reviewers['default'].Header, null),
                        _pullRequestTableComponentsWebSection.afterSections.map(function (section) {
                            return _React['default'].createElement(_pullRequestTableComponentsWebSection.WebSectionTH, { key: section.key + '::after', webSection: section });
                        })
                    );
                },
                row: function (_ref) {
                    var item = _ref.item;
                    var focused = _ref.focused;

                    var pullRequest = item;
                    return _React['default'].createElement(
                        _PullRequestRow['default'],
                        { key: pullRequest.id, focused: focused },
                        _React['default'].createElement(_Summary['default'], { pullRequest: pullRequest }),
                        _pullRequestTableComponentsWebSection.beforeSections.map(function (section) {
                            return _React['default'].createElement(_pullRequestTableComponentsWebSection.WebSectionTD, { key: section.key + '::before', where: 'before', webSection: section, pullRequest: pullRequest });
                        }),
                        _React['default'].createElement(_Comments['default'], { pullRequest: pullRequest }),
                        _React['default'].createElement(_Tasks['default'], { pullRequest: pullRequest }),
                        _React['default'].createElement(_Reviewers['default'], { pullRequest: pullRequest }),
                        _pullRequestTableComponentsWebSection.afterSections.map(function (section) {
                            return _React['default'].createElement(_pullRequestTableComponentsWebSection.WebSectionTD, { key: section.key + '::after', where: 'after', webSection: section, pullRequest: pullRequest });
                        })
                    );
                }
            }));
        };

        PullRequestListTable.propTypes = propTypes;

        module.exports = PullRequestListTable;
    }
);