define(
    'bitbucket/internal/bbui/codesearch/internal/search-data-provider',
    ['exports', 'module', 'lodash', 'bitbucket/internal/impl/data-provider/paged', 'bitbucket/internal/impl/search-urls', './search-request'],
    function (exports, module, _lodash, _bitbucketInternalImplDataProviderPaged, _bitbucketInternalImplSearchUrls, _searchRequest) {
        'use strict';

        var _slicedToArray = (function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i['return']) _i['return'](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError('Invalid attempt to destructure non-iterable instance'); } }; })();

        var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

        var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

        function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

        function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

        function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

        var _2 = _interopRequireDefault(_lodash);

        var _PagedDataProviderSPI2 = _interopRequireDefault(_bitbucketInternalImplDataProviderPaged);

        var _urls = _interopRequireDefault(_bitbucketInternalImplSearchUrls);

        var RE_MATCH = /<\/?em>/;

        var SearchDataProvider = (function (_PagedDataProviderSPI) {
            _inherits(SearchDataProvider, _PagedDataProviderSPI);

            function SearchDataProvider(options, initialData) {
                _classCallCheck(this, SearchDataProvider);

                _get(Object.getPrototypeOf(SearchDataProvider.prototype), 'constructor', this).call(this, options, initialData);
            }

            _createClass(SearchDataProvider, [{
                key: '_fetch',
                value: function _fetch(searchRequest) {
                    return this.options.search(searchRequest);
                }
            }, {
                key: '_transform',
                value: function _transform(result) {
                    return result[this.options.type].values.map(function (value) {
                        value.fileParts = value.file.split('/');
                        value.filename = value.fileParts.slice(-1);
                        // the first line number of the first hitContext
                        value.firstLineNumber = value.hitContexts[0][0].line;

                        // for every hitContext, filter lines with matches, and return the line numbers as a flattened array
                        var linesWithMatches = _2['default'].flatten(value.hitContexts.map(function (hitContext) {
                            return hitContext.filter(function (line) {
                                return line.line !== 0 && RE_MATCH.test(line.text);
                            }).map(function (line) {
                                return line.line;
                            });
                        }));
                        var groupedLines = linesWithMatches.reduce(function (_ref, line) {
                            var _ref2 = _slicedToArray(_ref, 2);

                            var lastLine = _ref2[0];
                            var data = _ref2[1];

                            if (line === lastLine + 1) {
                                if (Array.isArray(data[data.length - 1])) {
                                    data[data.length - 1].push(line);
                                } else {
                                    data.pop();
                                    data.push([lastLine, line]);
                                }
                            } else {
                                data.push(line);
                            }
                            return [line, data];
                        }, [-1, []])[1];
                        var lineHash = groupedLines.map(function (item) {
                            return Array.isArray(item) ? item[0] + '-' + item[item.length - 1] : item;
                        }).join(',');
                        value.fileUrl = _urls['default'].fileUrl(value.repository, value.file, lineHash);

                        // we moved avatar_url -> avatarUrl in the REST response, but still need avatar_url to work with the shared
                        // component avatar
                        if (_2['default'].has(value, 'repository.avatarUrl')) {
                            value.repository.avatar_url = value.repository.avatarUrl;
                        }

                        if (_2['default'].has(value, 'repository.project.avatarUrl')) {
                            value.repository.project.avatar_url = value.repository.project.avatarUrl;
                        }

                        return value;
                    });
                }
            }, {
                key: '_validate',
                value: function _validate() {
                    return true;
                }
            }, {
                key: '_fetchNext',
                value: function _fetchNext(lastResponseData) {
                    var searchRequest = undefined;

                    if (lastResponseData) {
                        searchRequest = (0, _searchRequest.nextSearchFor)(this.options.query, this.options.type, this.options.limits, lastResponseData);
                    } else {
                        searchRequest = (0, _searchRequest.searchFor)(this.options.query, this.options.limits);
                    }
                    return this._fetch(searchRequest);
                }
            }, {
                key: '_reachedEnd',
                value: function _reachedEnd(lastResponseData) {
                    return lastResponseData[this.options.type].isLastPage;
                }
            }]);

            return SearchDataProvider;
        })(_PagedDataProviderSPI2['default']);

        module.exports = SearchDataProvider;
    }
);