define('bitbucket/internal/impl/urls', [
    'bitbucket/util/navbuilder',
    'bitbucket/internal/bbui/javascript-errors',
    'bitbucket/internal/bbui/urls',
    'bitbucket/internal/util/object'
], function (
    nav,
    errors,
    UrlsSPI,
    obj
) {
    'use strict';

    function Urls () {
        UrlsSPI.call(this);
    }

    obj.inherits(Urls, UrlsSPI);

    var fileChanges = function (repository, commitRange) {
        //throw new NotImplementedError();
    };

    Urls.prototype.avatarUrl = function (person, size) {
        var stashPerson = {
            avatarUrl: person.avatar_url
        };
        return nav._avatarUrl(stashPerson, size).build();
    };

    Urls.prototype.pullRequest = function (pullRequest) {
        return nav.currentRepo().pullRequest(pullRequest).build();
    };

    Urls.prototype.createPullRequest = function(repository){
        return nav.project(repository.project).repo(repository).createPullRequest().build();
    };

    Urls.prototype.allPullRequests = function(repository){
        return nav.project(repository.project).repo(repository).allPullRequests().build();
    };

    Urls.prototype.help = function(key) {
        switch(key) {
            case 'help.mirroring.clone.dialog':
                return bitbucket_help_url('bitbucket.help.mirroring.clone.dialog');
            case 'help.mirroring.getting.started':
                return bitbucket_help_url('bitbucket.help.mirroring.getting.started');
            case 'help.mirroring.setup':
                return bitbucket_help_url('bitbucket.help.mirroring.setup.guide');
            case 'help.pull.request':
                return bitbucket_help_url('bitbucket.help.pull.request');
            default:
                throw new errors.NotImplementedError();
        }
    };

    Urls.prototype.search = function (terms) {
        return nav.search(terms).build();
    };

    Urls.prototype.project = function(project) {
        return nav.project(project).build();
    };

    Urls.prototype.repo = function(repository) {
        return nav.project(repository.project).repo(repository).build();
    };

    Urls.prototype.user = function(user) {
        return nav.user(user.slug).build();
    };

    return new Urls();
});
