define(
    'bitbucket/internal/bbui/pull-request-table',
    ['exports', 'module', 'aui', 'jquery', 'lodash', 'bitbucket/internal/impl/urls', 'bitbucket/internal/impl/web-fragments', './avatar-list', './avatars', './paged-table', './ref-label', './time'],
    function (exports, module, _aui, _jquery, _lodash, _bitbucketInternalImplUrls, _bitbucketInternalImplWebFragments, _avatarList, _avatars, _pagedTable, _refLabel, _time) {
        'use strict';

        var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

        var _get = function get(_x2, _x3, _x4) { var _again = true; _function: while (_again) { var object = _x2, property = _x3, receiver = _x4; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x2 = parent; _x3 = property; _x4 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

        function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

        function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

        function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

        var _AJS = _interopRequireDefault(_aui);

        var _$ = _interopRequireDefault(_jquery);

        var _2 = _interopRequireDefault(_lodash);

        // for soy

        var _AvatarList = _interopRequireDefault(_avatarList);

        // for soy

        var _PagedTable2 = _interopRequireDefault(_pagedTable);

        // for soy

        var customMapping = {
            aMomentAgo: function aMomentAgo() {
                return _AJS['default'].I18n.getText('bitbucket.pull.request.updated.date.format.a.moment.ago');
            },
            oneMinuteAgo: function oneMinuteAgo() {
                return _AJS['default'].I18n.getText('bitbucket.pull.request.updated.date.format.one.minute.ago');
            },
            xMinutesAgo: function xMinutesAgo(param) {
                return _AJS['default'].I18n.getText('bitbucket.pull.request.updated.date.format.x.minutes.ago', param);
            },
            oneHourAgo: function oneHourAgo() {
                return _AJS['default'].I18n.getText('bitbucket.pull.request.updated.date.format.one.hour.ago');
            },
            xHoursAgo: function xHoursAgo(param) {
                return _AJS['default'].I18n.getText('bitbucket.pull.request.updated.date.format.x.hours.ago', param);
            },
            oneDayAgo: function oneDayAgo() {
                return _AJS['default'].I18n.getText('bitbucket.pull.request.updated.date.format.one.day.ago');
            },
            xDaysAgo: function xDaysAgo(param) {
                return _AJS['default'].I18n.getText('bitbucket.pull.request.updated.date.format.x.days.ago', param);
            },
            oneWeekAgo: function oneWeekAgo() {
                return _AJS['default'].I18n.getText('bitbucket.pull.request.updated.date.format.one.week.ago');
            },
            defaultType: function defaultType(param) {
                return _AJS['default'].I18n.getText('bitbucket.pull.request.updated.date.format.absolute', param);
            }
        };

        var PullRequestTable = (function (_PagedTable) {
            _inherits(PullRequestTable, _PagedTable);

            /**
             * @param {jQuery|HTMLElement} el - the element to render the pull request table in to.
             * @param {Object} options - Options for this PullRequestTable
             * @param {jQuery|HTMLElement} options.tableEl - The table element to use as a container for this PullRequestTable
             * @param {Repository} options.repository - The repository this PullRequestTable is displayed in
             */

            function PullRequestTable(el) {
                var options = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];

                _classCallCheck(this, PullRequestTable);

                options = _$['default'].extend({
                    tableEl: (0, _$['default'])(bitbucket.internal.component.pullRequestTable.main({ id: 'bitbucket-pull-request-table' }))
                }, options);

                (0, _$['default'])(el).append(options.tableEl);

                _get(Object.getPrototypeOf(PullRequestTable.prototype), 'constructor', this).call(this, options);

                this.$tbody = this.$table.find('tbody');

                _AvatarList['default'].init();
            }

            // We do a merge here so that we get all of the paged table defaults for focusOptions as well.

            _createClass(PullRequestTable, [{
                key: 'handleNewRows',
                value: function handleNewRows(data) {
                    var rowsHtml = data.map(function (pullRequest) {
                        return bitbucket.internal.component.pullRequestTable.row({
                            customMapping: customMapping,
                            pullRequest: pullRequest
                        });
                    });

                    this.$tbody.append(rowsHtml.join(''));
                }
            }, {
                key: 'handleErrors',
                value: function handleErrors(errors) {
                    console.error(errors);
                }
            }, {
                key: '_moveFocus',
                value: function _moveFocus() {
                    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
                        args[_key] = arguments[_key];
                    }

                    _get(Object.getPrototypeOf(PullRequestTable.prototype), '_moveFocus', this).apply(this, args);
                    // set browser focus on the PR title link
                    this._getFocusedItem().find(this.options.focusOptions.itemLinkSelector).focus();
                }
            }]);

            return PullRequestTable;
        })(_PagedTable2['default']);

        PullRequestTable.defaults = _2['default'].merge({}, _PagedTable2['default'].defaults, {
            autoLoad: true,
            allFetchedMessageHtml: bitbucket.internal.component.pullRequestTable.allFetched()
        });

        module.exports = PullRequestTable;
    }
);
// for soy
// for soy