define(
    'bitbucket/internal/bbui/participant-avatar-list',
    ['exports', 'module', 'react', 'classnames', './aui-react/inline-dialog', './participant-avatar', './self-reviewer'],
    function (exports, module, _react, _classnames, _auiReactInlineDialog, _participantAvatar, _selfReviewer) {
        'use strict';

        var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

        var _slicedToArray = (function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i['return']) _i['return'](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError('Invalid attempt to destructure non-iterable instance'); } }; })();

        function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

        var _React = _interopRequireDefault(_react);

        var _classNames = _interopRequireDefault(_classnames);

        var _InlineDialog = _interopRequireDefault(_auiReactInlineDialog);

        var _ParticipantAvatar = _interopRequireDefault(_participantAvatar);

        var _SelfReviewer = _interopRequireDefault(_selfReviewer);

        var propTypes = {
            avatarSize: _react.PropTypes.string,
            currentUserAsReviewer: _react.PropTypes.object,
            maxOpen: _react.PropTypes.number,
            menuId: _react.PropTypes.string.isRequired,
            onSelfClick: _react.PropTypes.func.isRequired,
            participants: _react.PropTypes.array.isRequired,
            reverse: _react.PropTypes.bool,
            triggerClass: _react.PropTypes.string,
            permissionToReview: _react.PropTypes.bool.isRequired,
            pullRequestIsOpen: _react.PropTypes.bool.isRequired
        };

        var approvalOrder = {
            APPROVED: 1,
            NEEDS_WORK: 2,
            UNAPPROVED: 3
        };

        function sortParticipants(participants) {
            return participants.slice().sort(function (a, b) {
                return approvalOrder[a.state] - approvalOrder[b.state] || a.user.display_name.localeCompare(b.user.display_name);
            });
        }

        /**
         * Displays a list of avatars
         *
         * @param {Object} props - Component properties
         * @param {Array} props.participants - The participants
         * @param {string} props.menuId - ID for the overflow dialog
         * @param {string?} props.triggerClass - Additional classes for the overflow dialog trigger
         * @param {number?} props.maxOpen - Maximum number of participants to show before overflow
         * @param {string?} props.avatarSize - Avatar size to show participants at
         * @param {boolean?} props.reverse - Order to show participants
         * @returns {ReactElement} - rendered component
         */
        var ParticipantAvatarList = function ParticipantAvatarList(props) {
            var sortedParticipants = sortParticipants(props.participants);
            var currentUserIndex = sortedParticipants.indexOf(props.currentUserAsReviewer);
            var showingSelfReviewer = props.permissionToReview && props.pullRequestIsOpen;
            var maxOpen = showingSelfReviewer ? props.maxOpen - 1 : props.maxOpen;
            if (currentUserIndex > -1) {
                // remove current user from ParticipantAvatarList,

                var _sortedParticipants$splice = sortedParticipants.splice(currentUserIndex, 1);

                var _sortedParticipants$splice2 = _slicedToArray(_sortedParticipants$splice, 1);

                var currentUser = _sortedParticipants$splice2[0];

                // put the currentUser in front when
                // SelfReviewer component is hidden
                if (!props.pullRequestIsOpen) {
                    sortedParticipants.unshift(currentUser);
                }
            }

            var visibleParticipants = undefined;
            var dialogParticipants = undefined;
            if (sortedParticipants.length > maxOpen) {
                visibleParticipants = sortedParticipants.slice(0, maxOpen - 1);
                dialogParticipants = sortedParticipants.slice(maxOpen - 1);
            } else {
                visibleParticipants = sortedParticipants;
                dialogParticipants = [];
            }

            var visibleAvatars = visibleParticipants.map(function (participant) {
                return _React['default'].createElement(_ParticipantAvatar['default'], {
                    participant: participant,
                    key: participant.user.name
                });
            });
            var children = visibleAvatars.slice();

            if (showingSelfReviewer) {
                children.unshift(_React['default'].createElement(_SelfReviewer['default'], _extends({
                    key: 'self_reviewer',
                    removeSelfModalId: 'remove-self-modal'
                }, props)));
            }

            if (dialogParticipants.length) {
                children.push(_React['default'].createElement(
                    _auiReactInlineDialog.InlineDialogTrigger,
                    {
                        key: 'trigger',
                        dialogId: props.menuId,
                        className: (0, _classNames['default'])('aui-button-subtle overflow-reviewers-trigger', props.triggerClass)
                    },
                    '+',
                    dialogParticipants.length
                ));
                children.push(_React['default'].createElement(
                    _InlineDialog['default'],
                    {
                        key: 'dialog',
                        id: props.menuId,
                        className: 'overflow-participants',
                        alignment: props.reverse ? 'left top' : 'bottom right'
                    },
                    _React['default'].createElement(
                        'div',
                        { className: 'avatar-dropdown' },
                        _React['default'].createElement(
                            'ul',
                            { className: 'aui-list-truncate' },
                            dialogParticipants.map(function (participant) {
                                return _React['default'].createElement(
                                    'li',
                                    { key: participant.user.name },
                                    _React['default'].createElement(_ParticipantAvatar['default'], { participant: participant, tooltip: false, nameOnly: true, withName: true })
                                );
                            })
                        )
                    )
                ));
            }

            return _React['default'].createElement(
                'div',
                { className: (0, _classNames['default'])('reviewers', { reversed: props.reverse }) },
                props.reverse ? children.reverse() : children
            );
        };

        ParticipantAvatarList.propTypes = propTypes;
        module.exports = ParticipantAvatarList;
    }
);
// instead shown in SelfReviewer component