import _ from 'lodash';
import $ from 'jquery';
import models from 'bitbucket/internal/models';

export default {
    updateApproval(listEl, participant) {
        var $avatars = $(listEl).find(".user-avatar[data-username='" + participant.getUser().getName() + "']");
        $avatars.toggleClass('badge-hidden', !participant.getApproved());
    },

    sortParticipants(participants) {
        function compare(a,b) {
            if (a.state === b.state) {
                return a.user.display_name.localeCompare(b.user.display_name);
            } else {
                return a.state === models.ApprovalState.APPROVED ? -1 : 1;
            }
            return 0;
        }
        return participants.sort(compare);
    },

    init: _.once(function() {
        $('.avatar-tooltip > .aui-avatar-inner > img').tooltip({
            hoverable: false,
            offset: 5,
            gravity: function() {
                // Always position on screen
                return $.fn.tipsy.autoNS.call(this) + $.fn.tipsy.autoWE.call(this);
            },
            delayIn: 0,
            live: true
        });
    })

};
