define(
    'bitbucket/internal/bbui/reducers/pull-request-reviewers',
    ['exports', 'module', 'lodash', '../actions/pull-request', '../models', '../utils/create-reducer', '../utils/merge-object-in-array', '../utils/replace-state-with-rollback'],
    function (exports, module, _lodash, _actionsPullRequest, _models, _utilsCreateReducer, _utilsMergeObjectInArray, _utilsReplaceStateWithRollback) {
        'use strict';

        var _createReducer;

        function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

        function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

        var _2 = _interopRequireDefault(_lodash);

        var _createReducer2 = _interopRequireDefault(_utilsCreateReducer);

        var _mergeObjectInArray = _interopRequireDefault(_utilsMergeObjectInArray);

        var _replaceWithRollback = _interopRequireDefault(_utilsReplaceStateWithRollback);

        module.exports = (0, _createReducer2['default'])([], (_createReducer = {}, _defineProperty(_createReducer, _actionsPullRequest.PR_CHANGE_REVIEWER_STATE, function (reviewers, action) {
            var reviewerFinder = function reviewerFinder(reviewer) {
                return action.payload.user && reviewer.user.name === action.payload.user.name;
            };
            var index = _2['default'].findIndex(reviewers, reviewerFinder);
            var currentReviewState = reviewers[index] && reviewers[index].state;

            return (0, _replaceWithRollback['default'])(reviewers, action, {
                forward: function forward() {
                    return (0, _mergeObjectInArray['default'])(reviewers, reviewerFinder, { state: action.payload.newState });
                },
                back: function back() {
                    return (0, _mergeObjectInArray['default'])(reviewers, reviewerFinder, { state: currentReviewState });
                }
            });
        }), _defineProperty(_createReducer, _actionsPullRequest.PR_CHANGE_SELF_REVIEWER, function (reviewers, action) {
            return (0, _replaceWithRollback['default'])(reviewers, action, {
                forward: function forward() {
                    switch (action.payload.selfAction) {
                        case _models.SelfAction.ADD_SELF:
                            return reviewers.concat([{
                                role: _models.ParticipantRole.REVIEWER,
                                state: _models.ApprovalState.UNAPPROVED,
                                user: action.payload.user
                            }]);
                        case _models.SelfAction.REMOVE_SELF:
                            var reviewersClone = _2['default'].extend([], reviewers);
                            return _2['default'].remove(reviewersClone, function (reviewer) {
                                return reviewer.user.name !== action.payload.user.name;
                            });
                        default:
                            console.warn('Unknown reviewer action');
                    }
                },
                back: function back() {
                    return action.payload;
                }
            });
        }), _createReducer));
    }
);