define(
    'bitbucket/internal/bbui/self-reviewer',
    ['exports', 'module', 'react', 'aui', 'classnames', './aui-react/inline-dialog', './models', './participant-avatar'],
    function (exports, module, _react, _aui, _classnames, _auiReactInlineDialog, _models, _participantAvatar) {
        'use strict';

        var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

        var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

        function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

        function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

        function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

        var _React = _interopRequireDefault(_react);

        var _AJS = _interopRequireDefault(_aui);

        var _classNames = _interopRequireDefault(_classnames);

        var _InlineDialog = _interopRequireDefault(_auiReactInlineDialog);

        var _ParticipantAvatar = _interopRequireDefault(_participantAvatar);

        var propTypes = {
            currentUserAsReviewer: _react.PropTypes.object,
            isWatching: _react.PropTypes.bool,
            onSelfClick: _react.PropTypes.func.isRequired,
            removeSelfModalId: _react.PropTypes.string.isRequired
        };

        var SelfReviewer = (function (_Component) {
            _inherits(SelfReviewer, _Component);

            function SelfReviewer() {
                _classCallCheck(this, SelfReviewer);

                _get(Object.getPrototypeOf(SelfReviewer.prototype), 'constructor', this).apply(this, arguments);
            }

            _createClass(SelfReviewer, [{
                key: 'createUnwatchMarkup',
                value: function createUnwatchMarkup() {
                    return { __html: _AJS['default'].I18n.getText('bitbucket.component.self.reviewer.unwatch.html') };
                }
            }, {
                key: 'render',
                value: function render() {
                    var _this = this;

                    var currentUserAsReviewer = this.props.currentUserAsReviewer;
                    var unWatchCheckbox = _React['default'].createElement(
                        'p',
                        null,
                        _React['default'].createElement(
                            'label',
                            null,
                            _React['default'].createElement('input', { ref: function (el) {
                                    return _this._unwatchCheckbox = el;
                                }, className: 'checkbox', type: 'checkbox' }),
                            _React['default'].createElement('span', { dangerouslySetInnerHTML: this.createUnwatchMarkup() })
                        )
                    );

                    if (!currentUserAsReviewer) {
                        return _React['default'].createElement(
                            'span',
                            {
                                ref: function (el) {
                                    return _AJS['default'].$(el).tooltip();
                                },
                                title: _AJS['default'].I18n.getText('bitbucket.component.self.reviewer.add'),
                                className: 'add-self'
                            },
                            _React['default'].createElement(
                                'button',
                                { onClick: function () {
                                        return _this.props.onSelfClick(_models.SelfAction.ADD_SELF);
                                    }, className: 'aui-button' },
                                '+'
                            )
                        );
                    }

                    return _React['default'].createElement(
                        'div',
                        { className: 'self-avatar' },
                        _React['default'].createElement(_ParticipantAvatar['default'], { participant: currentUserAsReviewer }),
                        _React['default'].createElement(
                            'span',
                            {
                                ref: function (el) {
                                    return _AJS['default'].$(el).tooltip();
                                },
                                title: _AJS['default'].I18n.getText('bitbucket.component.self.reviewer.remove'),
                                className: (0, _classNames['default'])('remove-self')
                            },
                            _React['default'].createElement(
                                _auiReactInlineDialog.InlineDialogTrigger,
                                {
                                    dialogId: this.props.removeSelfModalId,
                                    className: 'aui-button'
                                },
                                '–'
                            )
                        ),
                        _React['default'].createElement(
                            _InlineDialog['default'],
                            {
                                key: 'remove_self_dialog',
                                id: this.props.removeSelfModalId,
                                className: 'remove-self-dialog',
                                alignment: 'bottom right'
                            },
                            _React['default'].createElement(
                                'h5',
                                null,
                                _AJS['default'].I18n.getText('bitbucket.component.self.reviewer.remove.confirm.header')
                            ),
                            _React['default'].createElement(
                                'p',
                                null,
                                _AJS['default'].I18n.getText('bitbucket.component.self.reviewer.remove.confirm')
                            ),
                            this.props.isWatching ? unWatchCheckbox : null,
                            _React['default'].createElement(
                                'p',
                                null,
                                _React['default'].createElement(
                                    'button',
                                    {
                                        className: 'aui-button',
                                        onClick: function (e) {
                                            return _this.props.onSelfClick(_models.SelfAction.REMOVE_SELF, _this._unwatchCheckbox ? _this._unwatchCheckbox.checked : null);
                                        }
                                    },
                                    _AJS['default'].I18n.getText('bitbucket.component.self.reviewer.remove.confirm.button')
                                )
                            )
                        )
                    );
                }
            }]);

            return SelfReviewer;
        })(_react.Component);

        SelfReviewer.propTypes = propTypes;

        module.exports = SelfReviewer;
    }
);