define(
    'bitbucket/internal/bbui/quick-search',
    ['exports', 'module', 'aui', 'jquery', 'lodash', 'bitbucket/internal/impl/request', 'bitbucket/internal/impl/search-urls', 'bitbucket/internal/impl/urls', './avatars', './bb-panel', './quick-search/internal/analytics'],
    function (exports, module, _aui, _jquery, _lodash, _bitbucketInternalImplRequest, _bitbucketInternalImplSearchUrls, _bitbucketInternalImplUrls, _avatars, _bbPanel, _internalAnalytics) {
        'use strict';

        var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

        var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

        function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

        function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

        var _AJS = _interopRequireDefault(_aui);

        var _$ = _interopRequireDefault(_jquery);

        var _2 = _interopRequireDefault(_lodash);

        var _request = _interopRequireDefault(_bitbucketInternalImplRequest);

        var _searchUrls = _interopRequireDefault(_bitbucketInternalImplSearchUrls);

        var _urls = _interopRequireDefault(_bitbucketInternalImplUrls);

        // for the soy

        var _analytics = _interopRequireDefault(_internalAnalytics);

        var MIN_TERMS_DISPLAY = 3;
        var QUICKSEARCH_DEBOUNCE_TIMEOUT = 200;

        var isDirectionalKeyEvent = function isDirectionalKeyEvent(e) {
            return e.keyCode === _AJS['default'].keyCode.LEFT || e.keyCode === _AJS['default'].keyCode.UP || e.keyCode === _AJS['default'].keyCode.RIGHT || e.keyCode === _AJS['default'].keyCode.DOWN;
        };

        var QuickSearch = (function () {
            function QuickSearch(el, options) {
                var _this = this;

                _classCallCheck(this, QuickSearch);

                this.options = _extends({}, QuickSearch.defaultOptions, options);
                this.useContext = !!(this.options.project || this.options.repository);
                this.focusClass = this.options.focusClass || 'focus';
                this.navigableClass = this.options.navigableClass || 'navigable';
                this._doRepoSearch = _2['default'].debounce(function (terms) {
                    if (terms.length >= MIN_TERMS_DISPLAY) {
                        _this.doRepoSearch(terms);
                    }
                }, QUICKSEARCH_DEBOUNCE_TIMEOUT);

                var $searchBox = (0, _$['default'])(bitbucket.internal.component.quickSearch.searchBox());
                this.$input = $searchBox.find('#quick-search');
                (0, _$['default'])(el).replaceWith($searchBox);

                var $panel = (0, _$['default'])(bitbucket.internal.component.quickSearch.searchPanel());
                $panel.appendTo((0, _$['default'])('body'));
                this.panel = $panel[0];

                this.$quickSearchBox = $searchBox.closest('.aui-quicksearch');
                this.$spinner = $searchBox.find('.spinner');
                this.$codeSearchHint = $panel.find('.code-search-hint');
                this.$terms = this.$codeSearchHint.find('.terms');
                this.$searchMainPanel = $panel.find('.quick-search-main');
                this.$searchErrorPanel = $panel.find('.quick-search-error');

                this.$repoSearchResults = $panel.find('.repo-search-results');

                this.$repoSearchResults.on('mouseover', '.repository', function (e) {
                    var $repo = (0, _$['default'])(e.target).closest('.repository');
                    _this._focusRepo($repo);
                });
                this.$repoSearchResults.on('mouseleave', '.repository', function () {
                    _this._blurRepos();
                });
                this.$repoSearchResults.on('click', 'a', function (e) {
                    var $a = (0, _$['default'])(e.currentTarget);
                    _analytics['default'].resultClicked({
                        project: _this.options.project,
                        repository: _this.options.repository,
                        clickedProjectId: $a.attr('data-project-id'),
                        clickedRepoId: $a.attr('data-repo-id')
                    });
                });

                this.$input.on('focus', function (e) {
                    return _this._onFocus(e);
                });
                this.$input.on('keyup', function (e) {
                    return _this._onKeyUp(e);
                });
                this.$input.on('keydown', function (e) {
                    return _this._onKeyDown(e);
                });
                (0, _$['default'])($searchBox[0]).on('submit', function (e) {
                    return e.preventDefault();
                });

                this._lastSearch = null;
            }

            /*
             * This component does its own focus management via blur,focus,keydown rather than using `data-aui-trigger`.
             * We do this because there are cases where we don't want the dialog to open when the field is focused.
             * For example in a global context there is nothing to show the dialog should be hidden.
             *
             * When the search suggested operators are added we should be able to go back to `data-aui-trigger` on the input
             * because we will always have something to show in the dialog.
             */

            _createClass(QuickSearch, [{
                key: 'doCodeSearch',
                value: function doCodeSearch(terms) {
                    if (this.useContext) {
                        terms = this._getContext() + " " + terms;
                    }
                    window.location = _urls['default'].search(terms);
                }
            }, {
                key: 'doRepoSearch',
                value: function doRepoSearch(terms) {
                    var _this2 = this;

                    var startTime = Date.now();
                    this._spinnerStart();
                    _request['default'].rest({
                        type: 'POST',
                        url: _searchUrls['default'].searchRestUrl(),
                        data: {
                            query: terms,
                            entities: {
                                repositories: {}
                            },
                            limits: {
                                primary: 9
                            }
                        },
                        statusCode: {
                            '*': false
                        }
                    }).done(function (data) {
                        _this2.currentSearchTerms = terms;
                        _this2.$searchErrorPanel.hide();
                        _this2.$searchMainPanel.show();
                        _analytics['default'].resultsLoaded({
                            project: _this2.options.project,
                            repository: _this2.options.repository,
                            time: Date.now() - startTime,
                            query: terms
                        });
                        _this2.$repoSearchResults.html(bitbucket.internal.component.quickSearch.repositorySearchResults({
                            repos: data.repositories.values
                        }));
                    }).fail(function () {
                        _this2.$searchMainPanel.hide();
                        _this2.$searchErrorPanel.show();
                    }).always(function () {
                        _this2._spinnerStop();
                    });
                }
            }, {
                key: 'focus',
                value: function focus() {
                    this.$input.focus();
                }
            }, {
                key: '_getContext',
                value: function _getContext() {
                    var context = "";
                    if (this.options.repository) {
                        context = "project:" + this.options.project.key + " repo:" + this.options.repository.slug;
                    } else if (this.options.project) {
                        context = "project:" + this.options.project.key;
                    }
                    return context;
                }
            }, {
                key: '_blurRepos',
                value: function _blurRepos() {
                    this.$repoSearchResults.find('.' + this.navigableClass + '.' + this.focusClass).removeClass(this.focusClass);
                }
            }, {
                key: '_focusRepo',
                value: function _focusRepo($repo) {
                    this._blurRepos();
                    $repo.addClass(this.focusClass);
                }
            }, {
                key: '_handleUpAndDownKeys',
                value: function _handleUpAndDownKeys(event) {
                    event.preventDefault();
                    var current = this.$repoSearchResults.find('.' + this.navigableClass + '.' + this.focusClass);
                    var $next = undefined;

                    if (current.length === 0) {
                        if (event.keyCode === _AJS['default'].keyCode.DOWN) {
                            $next = this.$repoSearchResults.find('.' + this.navigableClass + ':first');
                        } else if (event.keyCode === _AJS['default'].keyCode.UP) {
                            $next = this.$repoSearchResults.find('.' + this.navigableClass + ':last');
                        }
                    } else if (event.keyCode === _AJS['default'].keyCode.DOWN) {
                        $next = current.next();
                    } else if (event.keyCode === _AJS['default'].keyCode.UP) {
                        $next = current.prev();
                    }

                    if ($next.length !== 0) {
                        this._focusRepo($next);
                    } else if (event.keyCode === _AJS['default'].keyCode.UP) {
                        // if at the top of the list drop the highlight so ENTER works for code search
                        this._blurRepos();
                    }
                }
            }, {
                key: '_onFocus',
                value: function _onFocus() {
                    var currentTerms = this.$input.val();
                    this._updatePanel(currentTerms.length >= MIN_TERMS_DISPLAY);
                    _analytics['default'].focused({
                        project: this.options.project,
                        repository: this.options.repository
                    });
                }
            }, {
                key: '_onKeyDown',
                value: function _onKeyDown(e) {
                    if (e.keyCode === _AJS['default'].keyCode.DOWN || e.keyCode === _AJS['default'].keyCode.UP) {
                        e.preventDefault();
                        this._handleUpAndDownKeys(e);
                    }
                }
            }, {
                key: '_onKeyUp',
                value: function _onKeyUp(e) {
                    var newTerms = this.$input.val().trim();
                    this._updatePanel(e.keyCode !== _AJS['default'].keyCode.ESCAPE && newTerms.length >= MIN_TERMS_DISPLAY);

                    if (e.keyCode === _AJS['default'].keyCode.ENTER) {
                        var $focused = this.$repoSearchResults.find('.repository.' + this.focusClass);
                        if ($focused.length > 0) {
                            $focused.find('a')[0].click();
                        } else if (newTerms.length >= 1) {
                            this.doCodeSearch(newTerms);
                        }
                        e.preventDefault();
                    } else if (isDirectionalKeyEvent(e)) {
                        // don't do anything on keyup as these are handled on keydown
                    } else {
                            this._updateSearchTerms(newTerms);
                            this._doRepoSearch(newTerms);
                        }
                }
            }, {
                key: '_spinnerStart',
                value: function _spinnerStart() {
                    this.$quickSearchBox.addClass('loading');
                    this.$spinner.spin();
                }
            }, {
                key: '_spinnerStop',
                value: function _spinnerStop() {
                    this.$spinner.spinStop();
                    this.$quickSearchBox.removeClass('loading');
                }
            }, {
                key: '_updateSearchTerms',
                value: function _updateSearchTerms(terms) {
                    this.$codeSearchHint.toggleClass('hidden', terms.length < MIN_TERMS_DISPLAY);
                    this.$terms.text(terms);
                }
            }, {
                key: '_updatePanel',
                value: function _updatePanel(open) {
                    if (open && this.currentSearchTerms !== this.$input.val()) {
                        this.$repoSearchResults.empty();
                    }
                    this.panel.open = open;
                }
            }]);

            return QuickSearch;
        })();

        module.exports = QuickSearch;

        QuickSearch.defaultOptions = {
            project: null,
            repository: null
        };
    }
);