define(
    'bitbucket/internal/bbui/pull-request-header/components/pull-request-more',
    ['exports', 'module', 'react', '../../aui-react/component', '../../models'],
    function (exports, module, _react, _auiReactComponent, _models) {
        'use strict';

        var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

        var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

        function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

        function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

        function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

        var _React = _interopRequireDefault(_react);

        var _AUIComponent = _interopRequireDefault(_auiReactComponent);

        var propTypes = {
            onMoreAction: _react.PropTypes.func.isRequired,
            isWatching: _react.PropTypes.bool.isRequired,
            conditions: _react.PropTypes.objectOf(_react.PropTypes.bool).isRequired,
            pullRequestState: _react.PropTypes.oneOf(Object.keys(_models.PullRequestState).map(function (k) {
                return _models.PullRequestState[k];
            }))
        };

        var PullRequestMore = (function (_Component) {
            _inherits(PullRequestMore, _Component);

            function PullRequestMore() {
                _classCallCheck(this, PullRequestMore);

                _get(Object.getPrototypeOf(PullRequestMore.prototype), 'constructor', this).apply(this, arguments);
            }

            _createClass(PullRequestMore, [{
                key: 'render',
                value: function render() {
                    var _this = this;

                    var editMenuItem = undefined;
                    var declineMenuItem = undefined;
                    var pullRequestIsOpen = this.props.pullRequestState === _models.PullRequestState.OPEN;

                    if (this.props.conditions.canEdit && pullRequestIsOpen) {
                        editMenuItem = _React['default'].createElement(
                            'li',
                            null,
                            _React['default'].createElement(
                                'button',
                                { className: 'aui-button aui-button-link', role: 'menuitem', 'data-action': 'edit' },
                                AJS.I18n.getText('bitbucket.component.pull.request.edit')
                            )
                        );
                    }
                    if (this.props.conditions.canDecline && pullRequestIsOpen) {
                        declineMenuItem = _React['default'].createElement(
                            'li',
                            null,
                            _React['default'].createElement(
                                'button',
                                { className: 'aui-button aui-button-link', role: 'menuitem', 'data-action': 'decline' },
                                AJS.I18n.getText('bitbucket.component.pull.request.decline')
                            )
                        );
                    }
                    return _React['default'].createElement(
                        'div',
                        null,
                        _React['default'].createElement(
                            'button',
                            {
                                className: 'pull-request-more-trigger aui-button aui-button-subtle aui-dropdown2-trigger aui-dropdown2-trigger-arrowless',
                                'aria-haspopup': 'true',
                                'aria-owns': 'pull-request-header-more'
                            },
                            _React['default'].createElement(
                                'span',
                                { className: 'aui-icon aui-icon-small aui-iconfont-more' },
                                AJS.I18n.getText('bitbucket.component.pull.request.more')
                            )
                        ),
                        _React['default'].createElement(
                            _AUIComponent['default'],
                            { id: 'pull-request-header-more', markup: '<div class="aui-style-default aui-dropdown2"></div>' },
                            _React['default'].createElement(
                                'ul',
                                { className: 'aui-list-truncate', onClick: function (e) {
                                        return _this.props.onMoreAction(e.target.dataset.action);
                                    } },
                                editMenuItem,
                                declineMenuItem,
                                _React['default'].createElement(
                                    'li',
                                    null,
                                    _React['default'].createElement(
                                        'button',
                                        { className: 'aui-button aui-button-link', role: 'menuitem', 'data-action': 'watch' },
                                        this.props.isWatching ? AJS.I18n.getText('bitbucket.component.pull.request.unwatch') : AJS.I18n.getText('bitbucket.component.pull.request.watch')
                                    )
                                )
                            )
                        )
                    );
                }
            }]);

            return PullRequestMore;
        })(_react.Component);

        PullRequestMore.propTypes = propTypes;

        module.exports = PullRequestMore;
    }
);
/* TODO:
 - plugin points
*/