define(
    'bitbucket/internal/bbui/pull-request-header/components/merge-button',
    ['exports', 'module', 'react', 'classnames', 'jquery', 'react-dom', './spinner'],
    function (exports, module, _react, _classnames, _jquery, _reactDom, _spinner) {
        'use strict';

        var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

        var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

        function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

        function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

        function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

        var _React = _interopRequireDefault(_react);

        var _classNames = _interopRequireDefault(_classnames);

        var _$ = _interopRequireDefault(_jquery);

        var _Spinner = _interopRequireDefault(_spinner);

        var defaultProps = {
            mergeable: {
                isChecking: false,
                canMerge: true
            }
        };

        var propTypes = {
            conflicted: _react.PropTypes.bool,
            mergeable: _react.PropTypes.shape({
                isChecking: _react.PropTypes.bool,
                canMerge: _react.PropTypes.bool
            }),
            onMergeClick: _react.PropTypes.func.isRequired,
            onMergeWarningClick: _react.PropTypes.func.isRequired,
            vetoes: _react.PropTypes.arrayOf(_react.PropTypes.shape({
                detailedMessage: _react.PropTypes.string.isRequired
            }))
        };

        var MergeButton = (function (_Component) {
            _inherits(MergeButton, _Component);

            function MergeButton() {
                _classCallCheck(this, MergeButton);

                _get(Object.getPrototypeOf(MergeButton.prototype), 'constructor', this).apply(this, arguments);
            }

            _createClass(MergeButton, [{
                key: 'componentDidMount',
                value: function componentDidMount() {
                    var node = (0, _reactDom.findDOMNode)(this);
                    (0, _$['default'])(node).tooltip({
                        gravity: 'ne',
                        live: true
                    });
                }
            }, {
                key: 'componentWillUpdate',
                value: function componentWillUpdate(nextProps) {
                    var node = (0, _reactDom.findDOMNode)(this);
                    if (nextProps.mergeable.isChecking) {
                        // the spinner will be shown, measure the button and set its width.
                        // use getBoundingClientRect to get the full width of the
                        // button (including borders)
                        var rect = node.getBoundingClientRect();
                        node.style.width = rect.right - rect.left + 'px';
                    } else {
                        node.style.width = '';
                    }
                }
            }, {
                key: 'componentDidUpdate',
                value: function componentDidUpdate() {
                    var node = (0, _reactDom.findDOMNode)(this);
                    // need to remove the original-title because tipsy will continue to show
                    // if it is not removed.
                    if (!node.getAttribute('title')) {
                        node.removeAttribute('original-title');
                    }
                }
            }, {
                key: 'onClick',
                value: function onClick() {
                    if (this.props.mergeable.canMerge) {
                        this.props.onMergeClick();
                    } else {
                        this.props.onMergeWarningClick();
                    }
                }
            }, {
                key: 'render',
                value: function render() {
                    var _this = this;

                    var mergeable = this.props.mergeable;
                    var _props = this.props;
                    var conflicted = _props.conflicted;
                    var _props$vetoes = _props.vetoes;
                    var vetoes = _props$vetoes === undefined ? [] : _props$vetoes;

                    var title = '';
                    if (!mergeable.canMerge) {
                        if (conflicted && (!vetoes || vetoes.length === 0)) {
                            title = AJS.I18n.getText('bitbucket.component.pull.request.merge.conflict.tooltip');
                        } else if (vetoes && vetoes.length === 1 && !conflicted) {
                            title = vetoes[0].detailedMessage;
                        } else {
                            title = AJS.I18n.getText('bitbucket.component.pull.request.merge.issue.tooltip');
                        }
                    }

                    var enabled = !mergeable.isChecking && mergeable.canMerge;

                    var content = undefined;
                    if (mergeable.isChecking) {
                        content = _React['default'].createElement(_Spinner['default'], null);
                    } else {
                        content = AJS.I18n.getText('bitbucket.component.pull.request.toolbar.merge');
                    }

                    var className = (0, _classNames['default'])('aui-button', 'merge-button');
                    return _React['default'].createElement(
                        'button',
                        { onClick: function () {
                                return _this.onClick();
                            }, className: className, 'aria-disabled': !enabled, disabled: !enabled, title: title },
                        content
                    );
                }
            }]);

            return MergeButton;
        })(_react.Component);

        MergeButton.defaultProps = defaultProps;
        MergeButton.propTypes = propTypes;

        module.exports = MergeButton;
    }
);