define(
    'bitbucket/internal/bbui/participant-avatar',
    ['exports', 'module', 'react', 'lodash', './aui-react/avatar', './models'],
    function (exports, module, _react, _lodash, _auiReactAvatar, _models) {
        'use strict';

        function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

        var _React = _interopRequireDefault(_react);

        var _2 = _interopRequireDefault(_lodash);

        var _Avatar = _interopRequireDefault(_auiReactAvatar);

        var propTypes = {
            avatarSize: _react.PropTypes.string,
            participant: _react.PropTypes.shape({
                user: _react.PropTypes.object.isRequired,
                state: _react.PropTypes.oneOf(_2['default'].values(_models.ApprovalState)).isRequired
            }).isRequired,
            withName: _react.PropTypes.bool
        };

        var visibleBadgeCssClass = {
            APPROVED: 'approved',
            NEEDS_WORK: 'needs-work'
        };

        var avatarBadges = [{
            className: visibleBadgeCssClass.APPROVED,
            text: AJS.I18n.getText('bitbucket.component.avatar.badge.approved')
        }, {
            className: visibleBadgeCssClass.NEEDS_WORK,
            text: AJS.I18n.getText('bitbucket.component.avatar.badge.needs.work')
        }];

        function participantTooltip(participant) {
            var name = participant.user.display_name || participant.user.name;
            var displayText = undefined;
            if (!participant.state || participant.state === _models.ApprovalState.UNAPPROVED) {
                displayText = name;
            } else if (participant.state === _models.ApprovalState.APPROVED) {
                displayText = AJS.I18n.getText('bitbucket.component.pull.request.reviewer.tooltip.approved', name);
            } else {
                displayText = AJS.I18n.getText('bitbucket.component.pull.request.reviewer.tooltip.needs.work', name);
            }
            return displayText;
        }

        var ParticipantAvatar = function ParticipantAvatar(props) {
            return _React['default'].createElement(_Avatar['default'], {
                person: props.participant.user,
                size: props.avatarSize,
                badges: avatarBadges,
                tooltipText: participantTooltip(props.participant),
                visibleBadge: props.participant.state ? visibleBadgeCssClass[props.participant.state] : '',
                withName: props.withName
            });
        };

        ParticipantAvatar.propTypes = propTypes;
        module.exports = ParticipantAvatar;
    }
);