define(
    'bitbucket/internal/bbui/codesearch/internal/search',
    ['exports', 'jquery', 'lodash', 'bitbucket/internal/impl/request', 'bitbucket/internal/impl/search-urls', './analytics', './search-data-provider', './search-request', './search-results-table'],
    function (exports, _jquery, _lodash, _bitbucketInternalImplRequest, _bitbucketInternalImplSearchUrls, _analytics, _searchDataProvider, _searchRequest, _searchResultsTable) {
        'use strict';

        Object.defineProperty(exports, '__esModule', {
            value: true
        });
        exports.search = search;
        exports.createSearch = createSearch;

        function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

        var _$ = _interopRequireDefault(_jquery);

        var _2 = _interopRequireDefault(_lodash);

        var _request = _interopRequireDefault(_bitbucketInternalImplRequest);

        var _searchUrls = _interopRequireDefault(_bitbucketInternalImplSearchUrls);

        var _Analytics = _interopRequireDefault(_analytics);

        var _SearchDataProvider = _interopRequireDefault(_searchDataProvider);

        var _SearchResultsTable = _interopRequireDefault(_searchResultsTable);

        var STATUS_SERVER_ERROR = 500;
        // List of all entity types currently supported for rendering by search
        var SUPPORTED_ENTITIES = ['code'];

        /**
         * Given a SearchRequest object, perform a search.
         * @param {Object} searchRequest - The parameters for this search.
         * @returns {Promise} request promise
         */

        function search(searchRequest) {
            var start = Date.now();

            var ajaxPromise = _request['default'].rest({
                type: 'POST',
                url: _searchUrls['default'].searchRestUrl(),
                data: searchRequest,
                statusCode: {
                    400: false, // 400 is returned for QueryInvalidException,
                    500: false }
            });

            // 500 is also handled gracefully by the search UI
            ajaxPromise.then(function (data) {
                var time = Date.now() - start;
                var repository = data.scope.repository;
                var project = repository ? repository.project : data.scope.project;
                _Analytics['default'].resultsLoaded({
                    repository: repository,
                    project: project,
                    time: time,
                    query: searchRequest.query,
                    results: data
                });
            });

            return ajaxPromise;
        }

        /**
         * Sets up and creates the search result UI within an element, with an initial query.
         * @param {jQuery|HTMLElement} el Element to render results in
         * @param {string} query - The initial query string
         * @param {Object} limits - The search paging limits
         * @param {Number} limits.primary - Primary search page size (eg. main results)
         * @param {Number} limits.secondary - Secondary search page size (eg. sidebar results)
         * @returns {Promise} Promise that resolves when the initial search completes
         */

        function createSearch(el, query, limits) {
            var searchResultsTable = undefined;
            var loadedResults = 0;

            // setup search data provider for query
            var $el = (0, _$['default'])(el);
            $el.empty(); // also unbinds event handlers

            // show the 'searching' spinner while we do the initial search
            $el.html(bitbucket.internal.component.codesearch.searching());
            var $searching = $el.find('.code-search-searching');
            $searching.find('.spin-container').spin();

            function handleServerError() {
                var $results = $el.find('.primary-results');
                var errorHtml = bitbucket.internal.component.codesearch.serverError();
                if (searchResultsTable) {
                    searchResultsTable.suspend();
                }

                if ($results.length) {
                    $results.append(errorHtml);
                } else {
                    $el.html(errorHtml);
                }
            }

            // perform initial search
            return search((0, _searchRequest.searchFor)(query, SUPPORTED_ENTITIES, limits)).then(function (initialResults) {
                $searching.remove();

                // setup SearchResultsTable for primary results
                var primaryResultType = _2['default'].findKey(initialResults, { category: 'primary' });
                var primaryResult = initialResults[primaryResultType];
                var dataProvider = new _SearchDataProvider['default']({
                    query: query,
                    search: search,
                    type: primaryResultType,
                    limits: limits
                }, initialResults);

                dataProvider.on('data-request-failed', function (error) {
                    handleServerError(error);
                });

                var repository = initialResults.scope.repository;
                var project = repository ? repository.project : initialResults.scope.project;
                var scope = {
                    repository: repository,
                    project: project
                };
                loadedResults = primaryResult.values.length;
                $el.html(bitbucket.internal.component.codesearch.results({
                    totalMatches: primaryResult.count,
                    totalResults: primaryResult.count,
                    loadedResults: loadedResults,
                    scope: scope
                }));

                $el.on('click', '.learnmore', function () {
                    return _Analytics['default'].learnMoreClicked();
                });

                searchResultsTable = new _SearchResultsTable['default']($el.find('.primary-results'), {
                    dataProvider: dataProvider,
                    scope: scope
                });
                searchResultsTable.init();

                var $progress = $el.find('.result-load-progress');
                dataProvider.on('data-loaded', function (data) {
                    loadedResults += data.length;
                    if (loadedResults >= primaryResult.count) {
                        $progress.hide();
                    } else {
                        $progress.html(bitbucket.internal.component.codesearch.resultLoadProgress({
                            loaded: loadedResults,
                            total: primaryResult.count
                        }));
                    }
                });

                return searchResultsTable;
            }).fail(function (xhr) {
                $searching.remove();
                if (xhr.status < STATUS_SERVER_ERROR) {
                    $el.html(bitbucket.internal.component.codesearch.badQuery({
                        query: query,
                        reason: xhr.responseText
                    }));
                } else {
                    handleServerError(xhr.responseJSON);
                }
            });

            // TODO render secondary results
        }
    }
);