import models from "bitbucket/internal/models";
import _ from 'lodash';

function strToNumber (str) {
    [].reduce.call(str, function (sum, c, i) {
        return sum + ((c.charCodeAt(0) * i) % 17);
    }, 0);
}

function user (overrides, str) {
    str += '';
    return _.extend({
        name: 'USER' + str,
        display_name: 'User ' + str,
        email_address: `user${str}@example.com`,
        is_active: true,
        is_admin: false,
        type: models.UserType.NORMAL,
        avatar_url: `http://example.com/user-${str}-avatar.png`
    }, overrides);
}

function participant(overrides, str) {
    return {
        role: models.ParticipantRole.PARTICIPANT,
        user: user(null, str),
        state: models.ApprovalState.UNREVIEWED
    };
}

function pullRequest(overrides, str) {
    str += '';
    var id = Number(str) || strToNumber(str);
    return _.extend({
        author: participant({ role: models.ParticipantRole.AUTHOR }, str + '_author'),
        created_date: new Date(2015, 9, 21).toISOString(),
        description: 'A pull request: ' + str,
        description_as_html: `<marquee><blink>A pull request: ${str.replace(/[`'"<>]/g, '')}</blink></marquee>`,
        from_ref: ref(null, str + '_from'),
        id,
        participants: [ participant({ role: models.ParticipantRole.PARTICIPANT }, str + '_participant') ],
        reviewers: [ participant({ role: models.ParticipantRole.REVIEWER }, str + '_reviewer') ],
        state: models.PullRequestState.OPEN,
        title: str + ' title',
        to_ref: ref(null, str + '_to'),
        updated_date: new Date(1955, 10, 5).toISOString(),
        version: 1
    }, overrides);
}

function ref (overrides, str) {
    str += '';
    return _.extend({
        id: 'refs/heads/' + str,
        display_id: str,
        type: models.RefType.BRANCH,
        is_default: false,
        latest_commit: 'c0ffee',
        repository: repository(null, str + '_repo')
    }, overrides);
}

function repository (overrides, str) {
    str += '';
    return _.extend({
        id: str,
        name: 'Repo ' + str,
        slug: 'repo-' + str.replace(/[^a-zA-Z0-9]+/g, '-'),
        is_forkable: true,
        is_public: false,
        origin: null,
        scm_id: models.scmId.GIT
    }, overrides);
}

function project (overrides, str) {
    return _.extend({
        id: str,
        key: 'PROJ' + str.replace(/[^a-zA-Z0-9]+/g, '').toUpperCase(),
        name: 'Project ' + str,
        type: models.ProjectType.NORMAL,
        owner: null,
        is_public: false
    }, overrides);
}

export default {
    user,
    participant,
    pullRequest,
    ref,
    repository,
    project
};
