define(
    'bitbucket/internal/bbui/quick-search/internal/analytics',
    ['exports', 'module', 'jquery', 'bitbucket/internal/impl/analytics', 'bitbucket/internal/impl/search-analytics-utils', '../../search-common/analytics'],
    function (exports, module, _jquery, _bitbucketInternalImplAnalytics, _bitbucketInternalImplSearchAnalyticsUtils, _searchCommonAnalytics) {
        'use strict';

        var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

        function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

        var _$ = _interopRequireDefault(_jquery);

        var _Analytics = _interopRequireDefault(_bitbucketInternalImplAnalytics);

        var _searchAnalyticsUtils = _interopRequireDefault(_bitbucketInternalImplSearchAnalyticsUtils);

        function commonAttributes(project, repository) {
            var attributes = {
                context: _searchAnalyticsUtils['default'].getPageContext()
            };
            if (repository) {
                attributes['repository.id'] = repository.id;
            }
            if (project) {
                attributes['project.id'] = project.id;
            }
            return attributes;
        }

        module.exports = {
            /**
             * @param {Object} options.repository
             * @param {Object} options.project
             */
            focused: function focused(options) {
                var attributes = commonAttributes(options.project, options.repository);
                _Analytics['default'].trigger('bitbucket.ui.quick-search.focused', attributes);
            },

            /**
             * @param {Object} options.repository
             * @param {Object} options.project
             * @param {String} options.query
             * @param {Number} options.time
             */
            resultsLoaded: function resultsLoaded(options) {
                var attributes = _extends({
                    time: options.time
                }, (0, _searchCommonAnalytics.queryAttributes)(options.query), commonAttributes(options.project, options.repository));

                _Analytics['default'].trigger('bitbucket.ui.quick-search.results.loaded', attributes);
            },

            /**
             *
             * @param {Object} options.repository
             * @param {Object} options.project
             * @param {Number} options.clickedProjectId
             * @param {Number} options.clickedRepoId
             */
            resultClicked: function resultClicked(options) {
                var attributes = _extends({
                    'clicked.project.id': options.clickedProjectId,
                    'clicked.repository.id': options.clickedRepoId
                }, commonAttributes(options.project, options.repository));

                _Analytics['default'].trigger('bitbucket.ui.quick-search.result.clicked', attributes);
            }
        };
    }
);