define(
    'bitbucket/internal/bbui/participant-avatar-list',
    ['exports', 'module', 'react', 'aui', 'classnames', './aui-react/avatar', './aui-react/inline-dialog', './models'],
    function (exports, module, _react, _aui, _classnames, _auiReactAvatar, _auiReactInlineDialog, _models) {
        'use strict';

        var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

        function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

        var _React = _interopRequireDefault(_react);

        var _AJS = _interopRequireDefault(_aui);

        var _classNames = _interopRequireDefault(_classnames);

        var _Avatar = _interopRequireDefault(_auiReactAvatar);

        var _InlineDialog = _interopRequireDefault(_auiReactInlineDialog);

        var _models2 = _interopRequireDefault(_models);

        var propTypes = {
            participants: _react.PropTypes.array.isRequired,
            menuId: _react.PropTypes.string.isRequired,
            triggerClass: _react.PropTypes.string,
            avatarSize: _react.PropTypes.string,
            reverse: _react.PropTypes.bool
        };

        function sortParticipants(participants) {
            return participants.sort(function (a, b) {
                if (a.state === b.state) {
                    return a.user.display_name.localeCompare(b.user.display_name);
                } else {
                    return a.state === _models2['default'].ApprovalState.APPROVED ? -1 : 1;
                }
                return 0;
            });
        }

        var avatarBadges = [{
            className: 'approved',
            text: _AJS['default'].I18n.getText('bitbucket.component.avatar.badge.approved')
        }, {
            className: 'needs-work',
            text: _AJS['default'].I18n.getText('bitbucket.component.avatar.badge.needs.work')
        }];

        var visibleBadgeCssClass = {
            NEEDS_WORK: 'needs-work',
            APPROVED: 'approved'
        };

        function getAvatar(participant, props) {
            return _React['default'].createElement(_Avatar['default'], _extends({
                person: participant.user,
                size: props.avatarSize,
                badges: avatarBadges,
                visibleBadge: participant.state ? visibleBadgeCssClass[participant.state] : ''
            }, props));
        }

        /**
         * Displays a list of avatars
         *
         * @param {Object} participants
         * @param {string} menuId
         * @param? {string} triggerClass
         * @param? {number} maxOpen
         * @param? {string} avatarSize
         * @param? {boolean} reverse
         */
        var ParticipantAvatarList = function ParticipantAvatarList(props) {
            var sortedParticipants = sortParticipants(props.participants);

            if (props.reverse) {
                sortedParticipants.reverse();
            }

            var visibleParticipants = props.reverse ? sortedParticipants.slice(-props.maxOpen) : sortedParticipants.slice(0, props.maxOpen);
            var dialogParticipants = props.reverse ? sortedParticipants.slice(0, -props.maxOpen) : sortedParticipants.slice(props.maxOpen);
            var visibleAvatars = visibleParticipants.map(function (p) {
                return getAvatar(p, { key: p.user.name });
            });

            if (!dialogParticipants.length) {
                return _React['default'].createElement(
                    'div',
                    { className: 'reviewers' },
                    visibleAvatars
                );
            }

            return _React['default'].createElement(
                'div',
                { className: 'reviewers' },
                _React['default'].createElement(
                    _auiReactInlineDialog.InlineDialogTrigger,
                    { dialogId: props.menuId, className: (0, _classNames['default'])('aui-button-subtle', props.triggerClass) },
                    '+',
                    dialogParticipants.length
                ),
                _React['default'].createElement(
                    _InlineDialog['default'],
                    { id: props.menuId, alignment: 'left top' },
                    _React['default'].createElement(
                        'div',
                        { className: 'avatar-dropdown' },
                        _React['default'].createElement(
                            'ul',
                            { className: 'aui-list-truncate' },
                            dialogParticipants.map(function (p) {
                                return _React['default'].createElement(
                                    'li',
                                    { key: p.user.name },
                                    getAvatar(p, { withName: true })
                                );
                            })
                        )
                    )
                ),
                visibleAvatars
            );
        };

        ParticipantAvatarList.propTypes = propTypes;
        module.exports = ParticipantAvatarList;
    }
);