define(
    'bitbucket/internal/bbui/aui-react/icon',
    ['exports', 'module', 'classnames', 'react'],
    function (exports, module, _classnames, _react) {
        'use strict';

        function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

        var _classNames = _interopRequireDefault(_classnames);

        var _React = _interopRequireDefault(_react);

        var propTypes = {
            icon: _react.PropTypes.string.isRequired,
            size: _react.PropTypes.oneOf(['small', 'large'])
        };

        var defaultProps = {
            size: 'small'
        };

        var Icon = function Icon(props) {
            var icon = props.icon;
            if (!/^aui-iconfont-/.test(icon)) {
                icon = 'aui-iconfont-' + icon;
            }

            return _React['default'].createElement(
                'span',
                { className: (0, _classNames['default'])('aui-icon', 'aui-icon-' + props.size, icon) },
                props.children
            );
        };
        Icon.propTypes = propTypes;
        Icon.defaultProps = defaultProps;

        module.exports = Icon;
    }
);