define(
    'bitbucket/internal/bbui/aui-react/avatar',
    ['exports', 'classnames', 'lodash', 'react', 'bitbucket/internal/impl/urls'],
    function (exports, _classnames, _lodash, _react, _bitbucketInternalImplUrls) {
        'use strict';

        Object.defineProperty(exports, '__esModule', {
            value: true
        });

        var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

        var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

        var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

        function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

        function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

        function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

        var _classNames = _interopRequireDefault(_classnames);

        var _2 = _interopRequireDefault(_lodash);

        var _React = _interopRequireDefault(_react);

        var _urls = _interopRequireDefault(_bitbucketInternalImplUrls);

        /*
         * This file exposes a default UserAvatar, and a named ProjectAvatar.
         */

        var commonPropTypes = {
            avatarAttrs: _react.PropTypes.object,
            avatarClassName: _react.PropTypes.string,
            // A list of possible badges to show for this avatar.
            // These will always be present in the DOM, for animation purposes
            badges: _react.PropTypes.arrayOf(_react.PropTypes.shape({
                className: _react.PropTypes.string,
                // for accessibility
                text: _react.PropTypes.string
            })),
            // Will be set on the outer-most element
            className: _react.PropTypes.string,
            // T-shirt sizing
            size: _react.PropTypes.string,
            // Set to false when `withName` is true
            tooltip: _react.PropTypes.bool,
            // The single (if any) badge class name to be shown
            visibleBadge: _react.PropTypes.string,
            withLink: _react.PropTypes.bool,
            withName: _react.PropTypes.bool
        };

        var commonDefaultProps = {
            badges: [],
            size: 'small',
            tooltip: true,
            withName: false
        };

        var AvatarSizes = {
            'xsmall': 16,
            'small': 24,
            'medium': 32,
            'large': 48,
            'xlarge': 64,
            'xxlarge': 96,
            'xxxlarge': 128
        };

        var UserAvatar = (function (_Component) {
            _inherits(UserAvatar, _Component);

            function UserAvatar() {
                _classCallCheck(this, UserAvatar);

                _get(Object.getPrototypeOf(UserAvatar.prototype), 'constructor', this).apply(this, arguments);
            }

            _createClass(UserAvatar, [{
                key: 'getAvatarProps',
                value: function getAvatarProps() {
                    var user = this.props.person.user || this.props.person;
                    return {
                        avatarAttrs: { 'data-username': user.name },
                        avatarSrc: _urls['default'].avatarUrl(user, AvatarSizes[this.props.size]),
                        badges: this.props.badges,
                        className: (0, _classNames['default'])('user-avatar', this.props.avatarClassName, { 'badge-hidden': this.props.hideBadge }, this.props.withName ? null : this.props.className),
                        display: user.display_name || user.name,
                        displayLink: _urls['default'].user(user),
                        size: this.props.size,
                        tooltip: this.props.tooltip,
                        visibleBadge: this.props.visibleBadge
                    };
                }
            }, {
                key: 'render',
                value: function render() {
                    return _React['default'].createElement(AvatarWrapper, _extends({}, this.props, { avatarProps: this.getAvatarProps() }));
                }
            }]);

            return UserAvatar;
        })(_react.Component);

        exports['default'] = UserAvatar;

        UserAvatar.defaultProps = _extends({}, commonDefaultProps);
        UserAvatar.propTypes = _extends({}, commonPropTypes, {
            person: _react.PropTypes.object.isRequired
        });

        var ProjectAvatar = (function (_Component2) {
            _inherits(ProjectAvatar, _Component2);

            function ProjectAvatar() {
                _classCallCheck(this, ProjectAvatar);

                _get(Object.getPrototypeOf(ProjectAvatar.prototype), 'constructor', this).apply(this, arguments);
            }

            _createClass(ProjectAvatar, [{
                key: 'getAvatarProps',
                value: function getAvatarProps() {
                    return {
                        avatarSrc: this.props.project.avatar_url || 'XXX TODO TEST',
                        badges: this.props.badges,
                        className: 'aui-avatar-project',
                        display: this.props.project.name,
                        displayLink: 'XXX TODO TEST',
                        size: this.props.size,
                        tooltip: this.props.tooltip,
                        visibleBadge: this.props.visibleBadge
                    };
                }
            }, {
                key: 'render',
                value: function render() {
                    return _React['default'].createElement(AvatarWrapper, _extends({}, this.props, { avatarProps: this.getAvatarProps() }));
                }
            }]);

            return ProjectAvatar;
        })(_react.Component);

        exports.ProjectAvatar = ProjectAvatar;

        ProjectAvatar.defaultProps = _extends({}, commonDefaultProps, {
            avatarAttrs: {}
        });
        ProjectAvatar.propTypes = _extends({}, commonPropTypes, {
            project: _react.PropTypes.object.isRequired
        });

        /**
         * An AUI avatar.
         *
         * @param {string} display
         * @param {string} avatarSrc
         * @param {Object} [avatarAttrs] - Attributes to be added to the top level avatar element
         * @param {string} [size=small] - The avatar size (using t-shirt sizes)
         * @param {string} [className] - Classes to be added to the top level avatar element
         * @param {Object} [badge] - badge containing a `className` and optional `text`
         * @param {boolean} [tooltip=true] - Whether to show a tooltip for the avatar
         */
        var Avatar = function Avatar(props) {
            var display = props.display;
            var avatarSrc = props.avatarSrc;
            var size = props.size;
            var className = props.className;
            var avatarAttrs = props.avatarAttrs;

            var avatarClassNames = (0, _classNames['default'])(props.className, 'aui-avatar', 'aui-avatar-' + size, { 'aui-avatar-badged': props.badges.length });

            var imgAttrs = {
                alt: display,
                ref: props.tooltip ? function (el) {
                    return AJS.$(el).tooltip();
                } : null,
                src: avatarSrc,
                title: display
            };

            var badges = props.badges.map(function (badge) {
                var badgeClasses = (0, _classNames['default'])('badge', badge.className, { 'badge-hidden': props.visibleBadge !== badge.className });
                return _React['default'].createElement(
                    'span',
                    { key: badge.className, className: badgeClasses },
                    badge.text
                );
            });

            return _React['default'].createElement(
                'span',
                _extends({ className: avatarClassNames }, avatarAttrs),
                _React['default'].createElement(
                    'span',
                    { className: 'aui-avatar-inner' },
                    _React['default'].createElement('img', imgAttrs)
                ),
                badges
            );
        };

        /**
         * A wrapper to determine whether to show the avatar's display name or not.
         */
        var AvatarWrapper = function AvatarWrapper(props) {
            var avatarProps = props.avatarProps;

            if (!props.withName) {
                return _React['default'].createElement(Avatar, _extends({}, avatarProps, { className: (0, _classNames['default'])(avatarProps.className, props.className) }));
            }

            return _React['default'].createElement(
                'div',
                { className: (0, _classNames['default'])(props.className, 'avatar-with-name'), title: avatarProps.display },
                _React['default'].createElement(Avatar, _extends({}, avatarProps, { tooltip: false })),
                _React['default'].createElement(AvatarDisplay, { display: avatarProps.display, href: props.withLink ? avatarProps.displayLink : null })
            );
        };

        /**
         * The display name for an avatar, which may or may not be linked.
         */
        var AvatarDisplay = function AvatarDisplay(props) {
            var display = props.display;
            var href = props.href;

            if (href) {
                return _React['default'].createElement(
                    'a',
                    { href: href },
                    display
                );
            }

            return _React['default'].createElement(
                'span',
                null,
                display
            );
        };
    }
);