define(
    'bitbucket/internal/bbui/data-provider/paged',
    ['exports', 'module', './../javascript-errors', 'bitbucket/internal/impl/data-provider/data-provider', './../json-validation', 'jquery'],
    function (exports, module, _javascriptErrors, _bitbucketInternalImplDataProviderDataProvider, _jsonValidation, _jquery) {
        'use strict';

        var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

        var _get = function get(_x2, _x3, _x4) { var _again = true; _function: while (_again) { var object = _x2, property = _x3, receiver = _x4; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x2 = parent; _x3 = property; _x4 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

        function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

        function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

        function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

        var _errors = _interopRequireDefault(_javascriptErrors);

        var _DataProvider2 = _interopRequireDefault(_bitbucketInternalImplDataProviderDataProvider);

        var _validator = _interopRequireDefault(_jsonValidation);

        var _$ = _interopRequireDefault(_jquery);

        var PagedDataProvider = (function (_DataProvider) {
            _inherits(PagedDataProvider, _DataProvider);

            /**
             * @param {Object?} options - The options for the Data Provider
             * @param {Object?} options.filter - a set of parameters to filter the DataProvider
             * @param {?Object} initialData - The initial data for this provider
             */

            function PagedDataProvider() {
                var _get2;

                var options = arguments.length <= 0 || arguments[0] === undefined ? {} : arguments[0];

                _classCallCheck(this, PagedDataProvider);

                for (var _len = arguments.length, args = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
                    args[_key - 1] = arguments[_key];
                }

                (_get2 = _get(Object.getPrototypeOf(PagedDataProvider.prototype), 'constructor', this)).call.apply(_get2, [this, options].concat(args));
                // the untransformed last response fetched.
                this._lastPageData = null;

                if (options.filterDescriptor) {
                    this._validateFilter = (0, _validator['default'])(options.filterDescriptor);
                }

                this.filter = options.filter || {};
                this._validateFilter(this.filter);
            }

            /**
             * @type {boolean}
             * Whether the data provider has fetched the last page of data yet. Returns false before any data has been fetched.
             */

            _createClass(PagedDataProvider, [{
                key: '_validateFilter',

                /**
                 * Validates that the filter matches the shape expected by a subclass. By default, providers are assumed not to
                 * be filterable, and throw if any filter properties are set.
                 */
                value: function _validateFilter(f) {
                    if (Object.keys(f).length) {
                        throw new Error('No filter is expected on this data-provider.');
                    }
                }

                /**
                 * Set a filter property and reset the data provider
                 *
                 * @param {string} key
                 * @param {*} val
                 */
            }, {
                key: 'setFilter',
                value: function setFilter(key, val) {
                    if (this.filter) {
                        this.filter[key] = val;
                    }
                    if (this._validateFilter) {
                        this._validateFilter(this.filter);
                    }
                }
            }, {
                key: 'fetchNext',

                /**
                 * Fetch the next page of data. Duplicates lot's of logic in `fetch()`, but ignores `currentData` for caching.
                 * @returns {Promise} A promise that resolves to the transformed data
                 */
                value: function fetchNext() {
                    var _this = this;

                    if (this.reachedEnd) {
                        throw new Error('Nothing left to fetch.');
                    }

                    // If a fetch is attempted before the previous fetch has returned,
                    // then abort the previous fetch and continue with the new request.
                    this.abort();

                    // If there is initial data, upgrade the currentData to initialData
                    if (this.initialData) {
                        this._lastPageData = this.initialData;
                        this.currentData = this.transform(this.initialData);
                        // initialData is single use, delete it after it has been consumed
                        delete this.initialData;
                        return _$['default'].Deferred().resolve(this.currentData);
                    }

                    this.trigger('data-requested');

                    this._requestPromise = this._fetchNext(this._lastPageData);
                    if (!this._requestPromise.abort) {
                        throw new Error('no abort method on PagedDataProvider#_requestPromise.');
                    }

                    this._requestPromise.then(function (page) {
                        return _this._lastPageData = page;
                    });
                    return this._requestPromise.then(this.transform, function () {
                        return _$['default'].Deferred().reject(_this.errorTransform.apply(_this, arguments));
                    }).done(function (transformedData) {
                        _this.trigger('data-loaded', transformedData);
                        _this.currentData = transformedData;
                    }).fail(function (error) {
                        _this.trigger('data-request-failed', error);
                    }).always(function () {
                        _this._requestPromise = null;
                    });
                }
            }, {
                key: 'reset',
                value: function reset() {
                    this._lastPageData = null;
                    _get(Object.getPrototypeOf(PagedDataProvider.prototype), 'reset', this).call(this);
                }

                /**
                 * Given the last page retrieved, call `this._fetch(url)` with the correct URL for the next page of data.
                 * @param {*} lastPageData - the data returned by the last request, or null if no request has been made
                 * @returns {Promise} - must be abortable.
                 * @protected
                 */
            }, {
                key: '_fetchNext',
                value: function _fetchNext(lastPageData) {
                    throw new _errors['default'].NotImplementedError();
                }

                /**
                 * Whether the data provider has fetched the last page of data yet.
                 *
                 * @param {*} lastPageData - the data returned by the last request
                 * @returns {boolean}
                 * @protected
                 */
            }, {
                key: '_reachedEnd',
                value: function _reachedEnd(lastPageData) {
                    throw new _errors['default'].NotImplementedError();
                }
            }, {
                key: 'reachedEnd',
                get: function get() {
                    return this._lastPageData ? this._reachedEnd(this._lastPageData) : false;
                }
            }]);

            return PagedDataProvider;
        })(_DataProvider2['default']);

        module.exports = PagedDataProvider;
    }
);