define(
    'bitbucket/internal/bbui/mirror-clone-selector',
    ['exports', 'module', 'aui', 'lodash', 'jquery', 'bitbucket/internal/impl/urls', './widget', './javascript-errors'],
    function (exports, module, _aui, _lodash, _jquery, _bitbucketInternalImplUrls, _widget, _javascriptErrors) {
        'use strict';

        var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

        var _get = function get(_x, _x2, _x3) { var _again = true; _function: while (_again) { var object = _x, property = _x2, receiver = _x3; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x = parent; _x2 = property; _x3 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

        function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

        function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

        function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

        var _AJS = _interopRequireDefault(_aui);

        var _2 = _interopRequireDefault(_lodash);

        var _$ = _interopRequireDefault(_jquery);

        var _urls = _interopRequireDefault(_bitbucketInternalImplUrls);

        var _Widget2 = _interopRequireDefault(_widget);

        var _Errors = _interopRequireDefault(_javascriptErrors);

        var ELLIPSIS_PADDING = 15;

        var MirroringCloneSelector = (function (_Widget) {
            _inherits(MirroringCloneSelector, _Widget);

            /**
             * @typedef {Object} MinimalMirror
             * @param {String} id       - the mirror's ID
             * @param {String} name     - the mirror's name
             * @param {String} baseUrl  - the mirror's baseUrl
             * @param {String} url      - the path to the mirror repo info REST resource
             */

            /**
             * @typedef {Object} MirroredRepository
             * @param {String}              mirrorName  - the name of the mirror
             * @param {String}              id          - the ID of the mirror
             * @param {boolean}             available   - true if the repository is available on the mirror, false otherwise
             * @param {Object}              links       - a map of link type to link
             * @param {Array<NamedLink>}    links.clone - an array of clone urls available on the primary
             */

            /**
             * @typedef {Object} MinimalUpstreamServer
             * @param {String}              mirrorName  - the name
             * @param {Object}              links       - a map of link type to link
             * @param {Array<NamedLink>}    links.clone - an array of clone urls available on the primary
             */

            /**
             * @typedef {Object} NamedLink
             * @param {String} name - the type of link. Usually the protocol, for example: 'HTTP' or 'SSH'
             * @param {String} href - the URL - for this component usually a clone URL.
             */

            /**
             * Turns el into a mirroring clone URL selector.
             * @param el
             * @param {Object}                  options
             * @param {Array<MinimalMirror>}    options.mirrors                     - an array of minimal mirror objects
             * @param {MinimalUpstreamServer}   options.primary                     - an object describing the upstream server's configuration
             * @param {String}                  options.cloneUrlInput               - a jQuery selector for the input in which to display clone URLs
             * @param {String}                  options.mirrorClonePath             - the relative path to the REST resource for retrieving mirror clone URLs
             * @param {Function}                options.getCloneProtocol            - a function that returns the currently selected clone protocol
             * @param {boolean}                 [options.lazyLoad = true]           - don't load mirrors until the load() function is called
             * @param {String}                  [options.preferredMirrorId = null]  - the ID of the preferred mirror server, or null if none is set
             */

            function MirroringCloneSelector(el, options) {
                _classCallCheck(this, MirroringCloneSelector);

                _get(Object.getPrototypeOf(MirroringCloneSelector.prototype), 'constructor', this).call(this, options);
                this.$el = (0, _$['default'])(el);
                this.availableMirrors = [];
                this.clicked = false;
                this.init();
            }

            /**
             * Adds an available mirror to the list
             * @param {MirroredRepository} mirroredRepository
             */

            _createClass(MirroringCloneSelector, [{
                key: 'addMirror',
                value: function addMirror(mirroredRepository) {
                    if (mirroredRepository.available) {
                        this.availableMirrors.push(mirroredRepository);
                        var $availableMirrorsList = (0, _$['default'])('#available-mirror-list');
                        var $availableMirrors = $availableMirrorsList.find('li.mirror');
                        var $newMirror = (0, _$['default'])(bitbucket.internal.component.mirroringCloneSelector.mirrorItem({
                            item: mirroredRepository,
                            extraClasses: 'mirror'
                        }));
                        var $contextEl = _2['default'].find($availableMirrors, function (el) {
                            return (0, _$['default'])(el).text() > mirroredRepository.mirrorName;
                        });
                        if ($contextEl) {
                            $newMirror.insertBefore($contextEl);
                        } else {
                            $newMirror.appendTo($availableMirrorsList);
                        }

                        this.$trigger.removeAttr('disabled');

                        if (this.options.preferredMirrorId === mirroredRepository.id && !this.clicked) {
                            this.selectMirror(mirroredRepository.id);
                        }
                    }
                }

                /**
                 * Extracts the clone URL of the current protocol for the specified mirror
                 * @param {MirroredRepository|MinimalUpstreamServer} value
                 * @returns {String} the clone URL or an empty string
                 */
            }, {
                key: 'getCloneUrl',
                value: function getCloneUrl(value) {
                    return _2['default'].get(_2['default'].find(value.links.clone, 'name', this.getProtocol()), 'href', '');
                }

                /**
                 * @returns {String} the currently selected protocol
                 */
            }, {
                key: 'getProtocol',
                value: function getProtocol() {
                    return this.cloneProtocol || this.updateCloneProtocol(this.options.getCloneProtocol());
                }

                /**
                 * Hides the "clone from" dropdown, if it is showing.
                 */
            }, {
                key: 'hideDropdown',
                value: function hideDropdown() {
                    if (this.$dropdown.is(':visible')) {
                        this.$trigger.trigger('aui-button-invoke');
                    }
                }
            }, {
                key: 'init',
                value: function init() {
                    this.$el.html(bitbucket.internal.component.mirroringCloneSelector.main({ primary: this.options.primary }));
                    this.$trigger = this.$el.find('#available-mirrors-trigger');
                    this.$trigger.on('click', function (e) {
                        return e.preventDefault();
                    });
                    this.initMirrors();
                    this.initDropdown();
                }

                /**
                 * Initialize any dropdown handlers.
                 */
            }, {
                key: 'initDropdown',
                value: function initDropdown() {
                    var _this = this;

                    this.$dropdown = (0, _$['default'])('#available-mirrors');
                    /**
                     * @this {HTMLElement} the clicked element
                     */
                    this.$dropdown.on('click', '.mirror-item', function (e) {
                        e.preventDefault();
                        _this.selectMirror((0, _$['default'])(e.currentTarget).data('id'));
                        _this._updatePreferredMirror();
                        _this.clicked = true;
                    });
                }

                /**
                 * Sets up the component to load the mirrors.
                 * The selected mirror is loaded eagerly, the rest lazily.
                 */
            }, {
                key: 'initMirrors',
                value: function initMirrors() {
                    this.mirrorsToLoad = this.options.mirrors;
                    if (this.options.preferredMirrorId !== null) {
                        var preferredMirror = _2['default'].find(this.options.mirrors, 'id', this.options.preferredMirrorId);
                        if (preferredMirror) {
                            this.loadMirror(preferredMirror);
                            _2['default'].remove(this.mirrorsToLoad, 'id', preferredMirror.id);
                        }
                    }
                    if (!this.options.lazyLoad) {
                        this.load();
                    }
                }

                /**
                 * Loads all mirrors that have not yet been loaded.
                 */
            }, {
                key: 'load',
                value: function load() {
                    this.mirrorsToLoad.forEach(this.loadMirror);
                }

                /**
                 * Calls the mirror's REST API to check if it is available and retrieve clone URLs
                 * @param {MinimalMirror} mirror
                 */
            }, {
                key: 'loadMirror',
                value: function loadMirror(mirror) {
                    var _this2 = this;

                    _$['default'].ajax({
                        type: 'GET',
                        contentType: 'application/json',
                        url: mirror.url
                    }).done(function (response) {
                        var availableMirror = response;
                        availableMirror.id = mirror.id;
                        _this2.addMirror(availableMirror);
                    }).always(function () {
                        return _2['default'].remove(_this2.mirrorsToLoad, 'id', mirror.id);
                    });
                }

                /**
                 * Selects the mirror with the specified ID
                 * @param mirrorId
                 */
            }, {
                key: 'selectMirror',
                value: function selectMirror(mirrorId) {
                    this.currentMirrorId = mirrorId;
                    this.updateCloneUrl();
                }

                /**
                 * Show or hide the set push url instructions
                 * @param {boolean} visible
                 */
            }, {
                key: 'showSetPushUpstream',
                value: function showSetPushUpstream(visible) {
                    var $container = (0, _$['default'])('#update-push-url-container');
                    if (visible) {
                        (0, _$['default'])('#update-push-url-input').val('git remote set-url --push origin ' + this.getCloneUrl(this.options.primary));
                        $container.removeClass('hidden');
                    } else {
                        $container.addClass('hidden');
                    }
                }

                /**
                 * Updates the current clone protocol to the value supplied.
                 * This should be called by the component's host whenever the selected protocol changes.
                 * @param {String} protocol - the protocol to update the state to, for example 'ssh' or 'http'
                 * @returns {String} protocol
                 */
            }, {
                key: 'updateCloneProtocol',
                value: function updateCloneProtocol(protocol) {
                    this.cloneProtocol = protocol;
                    this.updateCloneUrl();
                    return protocol;
                }

                /**
                 * Sets the clone URL.
                 */
            }, {
                key: 'updateCloneUrl',
                value: function updateCloneUrl() {
                    var $cloneBox = (0, _$['default'])(this.options.cloneUrlInput);

                    var currentMirror = undefined;
                    if (!this.currentMirrorId) {
                        currentMirror = this.options.primary;
                        this.showSetPushUpstream(false);
                    } else {
                        currentMirror = _2['default'].find(this.availableMirrors, 'id', this.currentMirrorId);
                        this.showSetPushUpstream(true);
                    }

                    this.currentMirrorId = currentMirror.id;
                    this.$trigger.text(currentMirror.mirrorName);
                    $cloneBox.val(this.getCloneUrl(currentMirror));
                    $cloneBox.select();

                    // We need to set the maxWidth because: the label is i18n and can vary in width and the $trigger's width
                    // is controlled by AUI.
                    this.$trigger.css('maxWidth', this.$el.width() - this.$el.find('#clone-from-label').width() - ELLIPSIS_PADDING);
                }
            }, {
                key: '_updatePreferredMirror',
                value: function _updatePreferredMirror() {
                    this.options.preferredMirrorId = this.currentMirrorId;
                    this.updatePreferredMirror(this.options.preferredMirrorId);
                }

                //noinspection JSMethodCanBeStatic
                /**
                 * Persists the preferred mirror in some way.
                 * Must be implemented by consumer.
                 *
                 * @param {String} mirrorId - the ID of the new preferred mirror
                 */
            }, {
                key: 'updatePreferredMirror',
                value: function updatePreferredMirror(mirrorId) {
                    throw new _Errors['default'].NotImplementedError();
                }
            }]);

            return MirroringCloneSelector;
        })(_Widget2['default']);

        module.exports = MirroringCloneSelector;

        MirroringCloneSelector.defaults = {
            lazyLoad: true,
            preferredMirrorId: null
        };
    }
);