define(
    'bitbucket/internal/bbui/codesearch/internal/analytics',
    ['exports', 'module', 'jquery', 'bitbucket/internal/impl/analytics', '../../search-common/analytics'],
    function (exports, module, _jquery, _bitbucketInternalImplAnalytics, _searchCommonAnalytics) {
        'use strict';

        var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

        function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

        var _$ = _interopRequireDefault(_jquery);

        var _Analytics = _interopRequireDefault(_bitbucketInternalImplAnalytics);

        function addProjectRepo(project, repository) {
            var attributes = {};
            if (repository) {
                attributes['repository.id'] = repository.id;
            }
            if (project) {
                attributes['project.id'] = project.id;
            }
            return attributes;
        }

        module.exports = {
            /**
             * @param {Object} options.repository
             * @param {Object} options.project
             * @param {String} options.query
             * @param {Number} options.time
             * @param {Number} options.results
             */
            resultsLoaded: function resultsLoaded(options) {
                var attributes = _extends({
                    'code.count': options.results.code.count,
                    'code.start': options.results.code.start,
                    'time': options.time
                }, addProjectRepo(options.project, options.repository), (0, _searchCommonAnalytics.queryAttributes)(options.query));

                _Analytics['default'].trigger('bitbucket.ui.search.results.load', attributes);
            },

            bindTableAnalytics: function bindTableAnalytics($searchResults, repository, project) {
                var onFileClick = function onFileClick(e) {
                    var attributes = _extends({
                        'result.index': (0, _$['default'])(e.target).closest('li').index()
                    }, addProjectRepo(project, repository));
                    _Analytics['default'].trigger('bitbucket.ui.search.result.clicked', attributes);
                };
                $searchResults.on('click', '.code-search-filename', onFileClick);
                return function () {
                    $searchResults.off('click', '.code-search-filename', onFileClick);
                };
            },

            searchEverywhereClicked: function searchEverywhereClicked() {
                _Analytics['default'].trigger('bitbucket.ui.search.results.everywhere', {});
            },

            learnMoreClicked: function learnMoreClicked() {
                _Analytics['default'].trigger('bitbucket.ui.search.results.learnmore', {});
            }
        };
    }
);