define(
    'bitbucket/internal/bbui/codesearch/internal/search-request',
    ['exports', 'lodash'],
    function (exports, _lodash) {
        'use strict';

        Object.defineProperty(exports, '__esModule', {
            value: true
        });

        function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

        function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

        var _2 = _interopRequireDefault(_lodash);

        function searchFor(query, requestedEntities) {
            var entities = {};
            _2['default'].each(requestedEntities, function (key) {
                entities[key] = {};
            });

            return {
                query: query,
                entities: entities,
                limits: { // TODO parameterise
                    primary: 20,
                    secondary: 3
                }
            };
        }

        function nextSearchFor(query, type, previousResult) {
            var entities = _defineProperty({}, type, {
                start: previousResult[type].nextStart,
                limit: 50
            });

            return {
                query: query,
                entities: entities
            };
        }

        exports.searchFor = searchFor;
        exports.nextSearchFor = nextSearchFor;
    }
);