define(
    'bitbucket/internal/bbui/search-common/analytics',
    ['exports'],
    function (exports) {
        'use strict';

        Object.defineProperty(exports, '__esModule', {
            value: true
        });
        exports.queryAttributes = queryAttributes;

        function countModifier(query, modifier) {
            var match = query.match(new RegExp(modifier + ':\\S+', 'g'));
            return match && match.length || 0;
        }

        /**
         *
         * @param {Object} attributes the object to add the query info to.
         * @param {String} query
         */

        function queryAttributes(query) {
            return {
                'query.length': query.length,
                'term.count': query.split(" ").length,
                'mod.project': countModifier(query, 'project'),
                'mod.repo': countModifier(query, 'repo'),
                'mod.lang': countModifier(query, 'lang'),
                'mod.ext': countModifier(query, 'ext')
            };
        }
    }
);