define(
    'bitbucket/internal/bbui/reviewer-status',
    ['exports', 'module', 'aui', 'lodash', 'classnames', 'react', './models'],
    function (exports, module, _aui, _lodash, _classnames, _react, _models) {
        'use strict';

        function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

        var _AJS = _interopRequireDefault(_aui);

        var _2 = _interopRequireDefault(_lodash);

        var _classNames = _interopRequireDefault(_classnames);

        var _React = _interopRequireDefault(_react);

        var propTypes = {
            onStatusClick: _react.PropTypes.func.isRequired,
            status: _react.PropTypes.oneOf(_2['default'].values(_models.ApprovalState))
        };

        var titles = {
            approve: _AJS['default'].I18n.getText('bitbucket.component.reviewer.status.approve'),
            needsWork: _AJS['default'].I18n.getText('bitbucket.component.reviewer.status.needs.work'),
            markAsReviewing: _AJS['default'].I18n.getText('bitbucket.component.reviewer.status.mark.reviewing')
        };

        var ReviewerStatus = function ReviewerStatus(props) {
            function makeStatus(status, title, icon) {
                var isPressed = props.status === status;
                return _React['default'].createElement(
                    'button',
                    { className: 'aui-button', 'aria-pressed': isPressed,
                        title: isPressed ? titles.markAsReviewing : title,
                        onClick: function () {
                            return props.onStatusClick(isPressed ? _models.ApprovalState.UNREVIEWED : status);
                        },
                        ref: function (el) {
                            return _AJS['default'].$(el).tooltip();
                        } },
                    _React['default'].createElement(
                        'span',
                        { className: icon },
                        isPressed ? titles.markAsReviewing : title
                    )
                );
            }

            return _React['default'].createElement(
                'div',
                { className: 'aui-buttons reviewer-status' },
                makeStatus(_models.ApprovalState.NEEDS_WORK, titles.needsWork, 'needs-work'),
                makeStatus(_models.ApprovalState.APPROVED, titles.approve, 'approve')
            );
        };
        ReviewerStatus.propTypes = propTypes;

        module.exports = ReviewerStatus;
    }
);