define(
    'bitbucket/internal/bbui/codesearch/internal/push-state-manager',
    ['exports', 'module', '../../widget'],
    function (exports, module, _widget) {
        'use strict';

        var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

        var _get = function get(_x2, _x3, _x4) { var _again = true; _function: while (_again) { var object = _x2, property = _x3, receiver = _x4; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x2 = parent; _x3 = property; _x4 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

        function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

        function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

        function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

        var _Widget2 = _interopRequireDefault(_widget);

        //TODO: move this into its own component in the monorepo

        var PushStateManager = (function (_Widget) {
            _inherits(PushStateManager, _Widget);

            /**
             * @param {Object} [options]
             * @param {Object} [options.initialState] The initial state of the page.
             */

            function PushStateManager() {
                var options = arguments.length <= 0 || arguments[0] === undefined ? {} : arguments[0];

                _classCallCheck(this, PushStateManager);

                _get(Object.getPrototypeOf(PushStateManager.prototype), 'constructor', this).call(this, options);
                if (options.initialState) {
                    history.replaceState(options.initialState, null);
                }
                this._initPopState();
            }

            /**
             * Push a new state of the page
             *
             * @param {Object} state An object representing the state of the page.
             * @param {String} title The title of the page (This property is unused by all browser but required, null is a sensible value).
             * @param {String} url   The new URL that the page should be showing
             */

            _createClass(PushStateManager, [{
                key: 'pushState',
                value: function pushState(state, title, url) {
                    history.pushState(state, title, url);
                }
            }, {
                key: '_initPopState',
                value: function _initPopState() {
                    var _this = this;

                    var listener = function listener(e) {
                        _this.trigger('popstate', e);
                    };
                    window.addEventListener('popstate', listener);

                    this._addDestroyable(function () {
                        window.removeEventListener('popstate', listener);
                    });
                }
            }]);

            return PushStateManager;
        })(_Widget2['default']);

        module.exports = PushStateManager;
    }
);