define(
    'bitbucket/internal/bbui/mirroring-admin',
    ['exports', 'module', 'aui', 'aui/flag', 'jquery', 'lodash', 'bitbucket/internal/impl/request', 'bitbucket/internal/impl/urls', './list-and-detail-view', './mirroring-admin/mirror-view/mirror-view', './mirroring-admin/nav-builder', './mirroring-admin/request-view/request-view', './widget'],
    function (exports, module, _aui, _auiFlag, _jquery, _lodash, _bitbucketInternalImplRequest, _bitbucketInternalImplUrls, _listAndDetailView, _mirrorViewMirrorView, _navBuilder, _requestViewRequestView, _widget) {
        'use strict';

        var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

        var _get = function get(_x3, _x4, _x5) { var _again = true; _function: while (_again) { var object = _x3, property = _x4, receiver = _x5; _again = false; if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { _x3 = parent; _x4 = property; _x5 = receiver; _again = true; desc = parent = undefined; continue _function; } } else if ('value' in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } } };

        function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

        function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) arr2[i] = arr[i]; return arr2; } else { return Array.from(arr); } }

        function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

        function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

        function _inherits(subClass, superClass) { if (typeof superClass !== 'function' && superClass !== null) { throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

        var _AJS = _interopRequireDefault(_aui);

        var _auiFlag2 = _interopRequireDefault(_auiFlag);

        var _$ = _interopRequireDefault(_jquery);

        var _2 = _interopRequireDefault(_lodash);

        var _ajax = _interopRequireDefault(_bitbucketInternalImplRequest);

        var _urls = _interopRequireDefault(_bitbucketInternalImplUrls);

        var _ListAndDetailView = _interopRequireDefault(_listAndDetailView);

        var _MirrorView = _interopRequireDefault(_mirrorViewMirrorView);

        var _nav = _interopRequireDefault(_navBuilder);

        var _RequestView = _interopRequireDefault(_requestViewRequestView);

        var _Widget2 = _interopRequireDefault(_widget);

        /**
         * @typedef MirrorStatus
         */
        var MIRROR_STATUS = {
            ONLINE: 'online',
            OFFLINE: 'offline'
        };
        /**
         * @typedef MirrorRequest
         * @type {object}
         * @param {string} id           - the request's id
         * @param {string} mirrorName   - the requesting mirror's name
         */

        /**
         * @typedef Mirror
         * @type {object}
         * @param {string} id      - the mirror's id
         * @param {string} name    - the mirror's name
         * @param {string} baseUrl - the mirror's base URL
         */

        /**
         * Determines if the object contains only undefined or empty child objects
         * @param value
         * @return {boolean} true if all child nodes are undefined, false otherwise
         */
        function isEmpty(value) {
            return _2['default'].isEmpty(value) || !_2['default'].any(value, function (value) {
                return !_2['default'].isEmpty(value);
            });
        }

        /**
         * Log a warning message when the list failed to refresh.
         * @param {object} response - the AJAX response object
         */
        function failedToRefresh(response) {
            var errors = _2['default'].get(response, 'responseJSON.errors');
            if (errors) {
                // one of our REST errors
                var errorMessage = errors.map(function (obj) {
                    return obj.message;
                }).join('');
                console.warn('Failed to refresh list. Error: ' + errorMessage);
            }
            throw response; // some other error; Bubble it up.
        }

        var MirroringAdmin = (function (_Widget) {
            _inherits(MirroringAdmin, _Widget);

            /**
             * Control for the entire mirroring admin UI panel.
             * @param {HTMLElement} el - the element the UI panel is to be contained in
             * @param {object} options
             * @param {Array<Mirror>}        [options.mirrors]              - the mirrors to show in the list
             * @param {Array<MirrorRequest>} [options.requests]             - the mirroring requests to show in the list
             * @param {boolean}              [options.unavailable]          - indicates if the feature is available
             * @param {string}               [options.unavailableMessage]   - an i18n'd string to add to the empty state if the
             *                                                                feature is not available. May not contain HTML.
             * @param {int}                  [options.refreshInterval]      - the number of ms at which to poll for new mirrors
             *                                                                and requests
             */

            function MirroringAdmin(el, options) {
                var _this = this;

                _classCallCheck(this, MirroringAdmin);

                _get(Object.getPrototypeOf(MirroringAdmin.prototype), 'constructor', this).call(this, options);
                this.$el = (0, _$['default'])(el);

                if (this.options.unavailable) {
                    this.$el.html(bitbucket.internal.component.mirroringAdmin.main({
                        isEmpty: true,
                        unavailableText: _AJS['default'].escapeHtml(this.options.unavailableMessage)
                    }));
                } else {
                    this.navListItems = {
                        mirror: {},
                        request: {}
                    };
                    this.options.requests.forEach(function (item) {
                        return _this.addToNavListItems(item, 'request');
                    });
                    this.options.mirrors.forEach(function (item) {
                        return _this.addToNavListItems(item, 'mirror');
                    });

                    this.$el.html(bitbucket.internal.component.mirroringAdmin.main({ isEmpty: isEmpty(this.navListItems) }));

                    this.listAndDetailView = new _ListAndDetailView['default'](this.$el.find('.mirroring-admin'), {
                        selectHandler: this.itemSelectedHandler,
                        selectFirstOnInit: true,
                        selectedClass: 'selected-item',
                        listContent: bitbucket.internal.component.mirroringAdmin.navbar({
                            mirrors: this.options.mirrors,
                            requests: this.options.requests
                        })
                    });

                    this.setPolling();
                    (0, _$['default'])(document).on('visibilitychange', function () {
                        _this.setPolling(document.hidden ? 10 : 1);
                    });
                }
            }

            _createClass(MirroringAdmin, [{
                key: 'destroy',
                value: function destroy() {
                    clearTimeout(this.timeout);
                    clearInterval(this.statusInterval);
                    _get(Object.getPrototypeOf(MirroringAdmin.prototype), 'destroy', this).call(this);
                    this.$el.empty();
                    this.$el = null;
                }
            }, {
                key: 'addToNavListItems',
                value: function addToNavListItems(item, type) {
                    this.navListItems[type][item.id] = item;
                }

                /**
                 * Sets the poll operations to poll at their configured intervals times the
                 * specified multiplier.
                 *
                 * @param {number} [multiplier = 1]
                 */
            }, {
                key: 'setPolling',
                value: function setPolling() {
                    var multiplier = arguments.length <= 0 || arguments[0] === undefined ? 1 : arguments[0];

                    if (multiplier <= 0) {
                        console.warn('Poll multiplier must be greater than 0.');
                        return;
                    }
                    this.multiplier = multiplier;
                    clearTimeout(this.timeout);
                    clearInterval(this.statusInterval);

                    if (this.options.refreshInterval) {
                        this.timeout = setTimeout(this.refreshList, this.options.refreshInterval * multiplier);
                    }
                    this.checkMirrorStatus(multiplier);
                }

                /**
                 * Sets up a poll at intervalMinutes minute intervals to check the
                 * connected mirror's status' and updates the UI accordingly.
                 *
                 * @param {number} [intervalMinutes = 1]
                 */
            }, {
                key: 'checkMirrorStatus',
                value: function checkMirrorStatus() {
                    var _this2 = this;

                    var intervalMinutes = arguments.length <= 0 || arguments[0] === undefined ? 1 : arguments[0];

                    var frequency = 60 * 1000 * intervalMinutes;
                    var setAndPipeMirrorStatus = function setAndPipeMirrorStatus(mirror, status) {
                        _this2.setMirrorStatus(mirror, status);
                        return status;
                    };

                    var healthCheck = function healthCheck() {
                        if (_this2.navListItems.mirror) {
                            var requests = _2['default'].map(_this2.navListItems.mirror, function (mirror) {
                                // We use jQuery's ajax directly here, becuase this is a
                                // CORS call. The request will fail if we use ajax.rest,
                                // as the Server implementation adds headers that are not
                                // allowed by browsers without a pre-flight request. The
                                // '/status' endpoint does not handle pre-flight requests.
                                return _$['default'].ajax(mirror.baseUrl + '/status', {
                                    method: 'HEAD',
                                    timeout: frequency
                                }).then(function () {
                                    return setAndPipeMirrorStatus(mirror, MIRROR_STATUS.ONLINE);
                                }, function () {
                                    return setAndPipeMirrorStatus(mirror, MIRROR_STATUS.OFFLINE);
                                });
                            });
                            _this2._healthCheck = _$['default'].when.apply(_$['default'], _toConsumableArray(requests));
                        }
                    };

                    healthCheck();
                    this.statusInterval = setInterval(healthCheck, frequency);
                }
            }, {
                key: 'itemSelectedHandler',
                value: function itemSelectedHandler($selectedItem, $listView, $detailView, e) {
                    var type = $selectedItem.attr('data-type');
                    var id = $selectedItem.attr('data-id');
                    var viewData = { item: this.navListItems[type][id] };
                    if (!viewData.item) {
                        return;
                    }

                    if (this.currentView) {
                        this.currentView.destroy();
                    }

                    var ViewClass = this.options.views[type];
                    if (ViewClass) {
                        this.currentView = new ViewClass($detailView, viewData);
                        if (type === 'request') {
                            this.currentView.on('request-resolved', this.transitionItem);
                        } else if (type === 'mirror') {
                            this.currentView.on('mirror-removed', this.removeItem);
                        }
                    } else {
                        throw new Error('Invalid view type \'' + type + '\'');
                    }
                }

                /**
                 * Finds the element which to insert the given item before
                 * @returns {jQuery|HTMLElement} the element which to insert the given item before
                 */
            }, {
                key: 'findBeforeElement',
                value: function findBeforeElement() {
                    var $mirrors = this.listAndDetailView.$listView.find('.mirror'); // includes mirror-request items as well
                    return $mirrors.length ? $mirrors[0] : (0, _$['default'])('#learn-more-mirroring');
                }

                /**
                 * Remove an item from the listView.
                 * @param {RequestResolvedObject} options
                 */
            }, {
                key: 'removeItem',
                value: function removeItem(options) {
                    delete this.navListItems[options.type][options.id];
                    var $item = this.listAndDetailView.$listView.find('[data-id="' + options.id + '"][data-type="' + options.type + '"]');
                    this.listAndDetailView.removeItem($item, '.mirror');
                    this.updateEmptyState();
                }

                /**
                 * Remove any items that were not returned in the updated pages.
                 * This is to prevent a mirror and request showing up for the same mirror.
                 * @param {object} handledItems
                 */
            }, {
                key: 'removeStaleItems',
                value: function removeStaleItems(handledItems) {
                    var _this3 = this;

                    Object.keys(this.navListItems).forEach(function (type) {
                        var existingItemIds = Object.keys(_this3.navListItems[type] || {});
                        var newItemIds = Object.keys(handledItems[type] || {});
                        var staleItemIds = _2['default'].difference(existingItemIds, newItemIds);
                        staleItemIds.forEach(function (id) {
                            _this3.removeItem({
                                type: type,
                                id: id
                            });
                        });
                    });
                }

                /**
                 * Refreshes the listView.
                 * Calls the REST endpoint and updates the listView accordingly.
                 *
                 * @returns {Promise} a promise that completes when the list has refreshed
                 */
            }, {
                key: 'refreshList',
                value: function refreshList() {
                    var _this4 = this;

                    if (this.refreshPromise) {
                        return;
                    }

                    var requestsPromise = _ajax['default'].rest({
                        type: 'GET',
                        url: _nav['default'].rest().mirroring().path('requests').params({ state: 'pending' }).build(),
                        statusCode: {
                            '*': false
                        }
                    });

                    var mirrorsPromise = _ajax['default'].rest({
                        type: 'GET',
                        url: _nav['default'].rest().mirroring().path('mirrorServers').build(),
                        statusCode: {
                            '*': false
                        }
                    });

                    var handledItems = {};
                    var handleItem = function handleItem(item, type, template) {
                        if (!handledItems[type]) {
                            handledItems[type] = {};
                        }
                        handledItems[type][item.id] = item;
                        if (!_this4.navListItems[type] || !_this4.navListItems[type][item.id]) {
                            var selectItem = !_2['default'].some(_this4.navListItems, _2['default'].size);
                            _this4.addToNavListItems(item, type);
                            _this4.listAndDetailView.addItem((0, _$['default'])(template(_defineProperty({}, type, item))), _this4.findBeforeElement(), selectItem);
                        }
                    };

                    _AJS['default'].$('.list-refresh-spinner').spin();

                    var deferred = _$['default'].Deferred();
                    this.refreshPromise = _$['default'].when(requestsPromise, mirrorsPromise);
                    this.refreshPromise.always(function () {
                        _AJS['default'].$('.list-refresh-spinner').spinStop();
                        _this4.refreshPromise = null;
                        if (_this4.options.refreshInterval) {
                            _this4.timeout = setTimeout(_this4.refreshList, _this4.options.refreshInterval * _this4.multiplier);
                        }
                    }).done(function (requestPage, mirrorPage) {
                        requestPage[0].values.forEach(function (item) {
                            handleItem(item, 'request', bitbucket.internal.component.mirroringAdmin.mirrorRequestNavItem);
                        });
                        mirrorPage[0].values.forEach(function (item) {
                            handleItem(item, 'mirror', bitbucket.internal.component.mirroringAdmin.mirrorNavItem);
                        });
                        _this4.removeStaleItems(handledItems);
                        _this4.updateEmptyState();
                        deferred.resolve();
                    }).fail(function (e) {
                        failedToRefresh(e);
                        deferred.reject();
                    });

                    return deferred.promise();
                }

                /**
                 * Sets the mirror status in the UI.
                 *
                 * @param {Miror} mirror
                 * @param {MirrorStatus} status
                 */
            }, {
                key: 'setMirrorStatus',
                value: function setMirrorStatus(mirror, status) {
                    var $item = this.listAndDetailView.$listView.find('[data-id="' + mirror.id + '"][data-type="mirror"]');
                    var newStatus = bitbucket.internal.component.mirroringAdmin.mirrorStatus({ status: status });
                    var $statusContainer = $item.find('.status-container');
                    if (newStatus !== $statusContainer.html()) {
                        (function () {
                            $statusContainer.append(newStatus);

                            var $statuses = $item.find('.status');
                            var transitionClass = 'transitioning';
                            $statuses.one('transitionend', function () {
                                $statuses.last().removeClass(transitionClass);
                                $statuses.first().remove();
                            }).addClass(transitionClass);
                        })();
                    }
                }

                /**
                 * Hides or shows the empty state,
                 * depending on if there are mirroring requests/mirrors to show.
                 */
            }, {
                key: 'updateEmptyState',
                value: function updateEmptyState() {
                    var empty = isEmpty(this.navListItems);
                    (0, _$['default'])('.mirroring-admin').toggleClass('hidden', empty);
                    (0, _$['default'])('.empty-state').toggleClass('hidden', !empty);
                }

                /**
                 * Transitions an item based on the item's resolution
                 * Deleted items are removed, accepted items are transitioned.
                 * @param {RequestResolvedObject} options
                 */
            }, {
                key: 'transitionItem',
                value: function transitionItem(options) {
                    switch (options.resolution) {
                        case 'accept':
                            var $item = this.transformToMirror(options);
                            $item.click();
                            break;
                        case 'reject':
                            this.removeItem(options);
                            break;
                    }
                    this.updateEmptyState();
                }

                /**
                 * Transforms an existing mirroring nav item into a mirror nav item.
                 * @param {RequestResolvedObject} options
                 * @return {jQuery} the transformed nav item
                 */
            }, {
                key: 'transformToMirror',
                value: function transformToMirror(options) {
                    delete this.navListItems[options.type][options.id];
                    var mirror = options.responseJSON;
                    this.addToNavListItems(mirror, 'mirror');
                    var $item = this.listAndDetailView.$listView.find('[data-id="' + options.id + '"][data-type="' + options.type + '"]');
                    $item.removeClass('mirror-request');
                    $item.attr('data-id', mirror.id);
                    $item.attr('data-type', 'mirror');

                    this.setMirrorStatus(mirror, mirror.state);

                    return $item;
                }
            }]);

            return MirroringAdmin;
        })(_Widget2['default']);

        module.exports = MirroringAdmin;

        MirroringAdmin.defaults = {
            mirrors: [],
            requests: [],
            refreshInterval: 0, //Polling is _disabled_ by default.
            unavailable: false,
            unavailableMessage: '',
            views: {
                mirror: _MirrorView['default'],
                request: _RequestView['default']
            }
        };
    }
);